/*
CONNECT
  "d:\D_Projects\_wepak\db\wepak.gdb"
  USER "SYSDBA"
  PASSWORD "masterkey"
  Default character set WIN1250;
*/

SET SQL DIALECT 3;

SET NAMES  WIN1250;
/* ************** Functions for InterBase - UDF Tungli '2004 ********************* */

/* system datetime  use: F_Now() */
declare external function F_NOW
  returns CString(40)
  entry_point 'F_NOW' Module_Name 'FUN.DLL';

/* system date (without time) use: F_Today() */
declare external function F_TODAY
  returns CString(40)
  entry_point 'F_TODAY' Module_Name 'FUN.DLL';

/* formated datetime,  F_DATE(F_now(), 'yyyy.mm.dd hh:nn:ss.zzz') */
declare external function F_DATE
  CString(254), CString(254) returns CString(50)
  entry_point 'F_DATE' Module_Name 'FUN.DLL';

/* F_Year('15.1.2004')=2004 */
declare external function F_YEAR
  CString(254) returns integer by value
  entry_point 'F_YEAR' Module_Name 'FUN.DLL';

/* F_Month('15.1.2004')=1 */
declare external function F_MONTH
  CString(254) returns integer by value
  entry_point 'F_MONTH' Module_Name 'FUN.DLL';

/* F_Day('15.1.2004')=15 */
declare external function F_DAY
  CString(254) returns integer by value
  entry_point 'F_DAY' Module_Name 'FUN.DLL';

/* day of week: Sunday =1  & Saturday=7 */
declare external function F_WEEKDAY
  CString(254) returns integer by value
  entry_point 'F_WEEKDAY' Module_Name 'FUN.DLL';

/* day of week : Sunday =7  & Saturday=6 */
declare external function F_WDAY
  CString(254) returns integer by value
  entry_point 'F_WDAY' Module_Name 'FUN.DLL';

/* last day in mounth*/
declare external function F_LASTDAY
  CString(254) returns integer by value
  entry_point 'F_LASTDAY' Module_Name 'FUN.DLL';

/* delta days */
declare external function F_DAYS
  CString(254),CString(254) returns integer by value
  entry_point 'F_DAYS' Module_Name 'FUN.DLL';

/* ages in years */
declare external function F_AGES
  CString(254),CString(254) returns double precision by value
  entry_point 'F_AGES' Module_Name 'FUN.DLL';

/* Byte to character, F_Ch(64)='A' */
declare external function F_CH
  integer returns CString(1)
  entry_point 'F_CH' Module_Name 'FUN.DLL';

/* Length*/
declare external function F_LEN
  CString(254) returns integer by value
  entry_point 'F_LEN' Module_Name 'FUN.DLL';

/* F_Pos('a','beta')=4 */
declare external function F_POS
  CString(254), CString(254) returns integer by value
  entry_point 'F_POS' Module_Name 'FUN.DLL';

/* Trim */
declare external function F_TRIM
  CString(254) returns CString(254)
  entry_point 'F_TRIM' Module_Name 'FUN.DLL';

/* F_RTrim(' alfa ')=' alfa' */
declare external function F_RTRIM
  CString(254) returns CString(254)
  entry_point 'F_RTRIM' Module_Name 'FUN.DLL';

/* F_LTrim(' alfa ')='alfa ' */
declare external function F_LTRIM
  CString(254) returns CString(254)
  entry_point 'F_LTRIM' Module_Name 'FUN.DLL';

/* F_Copy(alfa,2,3)='lfa' */
declare external function F_COPY
  CString(254), integer,integer returns CString(254)
  entry_point 'F_COPY' Module_Name 'FUN.DLL';

/* F_Del('alfa',2,3)='a' */
declare external function F_DEL
  CString(254), integer,integer returns CString(254)
  entry_point 'F_DEL' Module_Name 'FUN.DLL';

/* F_Add('alfa','beta')='alfabeta' */
declare external function F_ADD
  CString(254),CString(254) returns CString(254)
  entry_point 'F_ADD' Module_Name 'FUN.DLL';

/* F_RepChars('alfa','al','12')='12f1' */
declare external function F_REPCHARS
  CString(254), CString(254), CString(254) returns CString(254)
  entry_point 'F_REPCHARS' Module_Name 'FUN.DLL';

/* F_Replace('Alfa','a','t')='tlft' ,  ignore case*/
declare external function F_REPLACE
  CString(254),CString(254),CString(254) returns CString(254)
  entry_point 'F_REPLACE' Module_Name 'FUN.DLL';

/*  F_Space1('  a    l  ')='a l'   */
declare external function F_SPACE1
  CString(254) returns CString(254)
  entry_point 'F_SPACE1' Module_Name 'FUN.DLL';

/* F_NoDiak('lf')='Alfa'   convert national chars to ASCII*/
declare external function F_NODIAK
  CString(254) returns CString(254)
  entry_point 'F_NODIAK' Module_Name 'FUN.DLL';

/* F_Lower('lf')='lf' */
declare external function F_LOWER
  CString(254) returns CString(254)
  entry_point 'F_LOWER' Module_Name 'FUN.DLL';

/* F_Upper('lf')='LF' */
declare external function F_UPPER
  CString(254) returns CString(254)
  entry_point 'F_UPPER' Module_Name 'FUN.DLL';

/* F_Case('3', '1=one | 2=two | 3=four  ..*=unknown')='four' */
declare external function F_CASE
  CString(254),CString(254) returns CString(254)
  entry_point 'F_CASE' Module_Name 'FUN.DLL';

/* F_Prefix('A',4)='   A' */
declare external function F_PREFIX
  CString(254), integer returns CString(254)
  entry_point 'F_PREFIX' Module_Name 'FUN.DLL';

/* max float */
declare external function F_MAX
  double precision, double precision returns double precision by value
  entry_point 'F_MAX' Module_Name 'FUN.DLL';

/* min float */
declare external function F_MIN
  double precision, double precision returns double precision by value
  entry_point 'F_MIN' Module_Name 'FUN.DLL';

/* Modulo F_MOD(12,10)=2 */
declare external function F_MOD
  double precision, double precision  returns integer by value
  entry_point 'F_MOD' Module_Name 'FUN.DLL';

/* ABS float */
declare external function F_ABS
  double precision returns double precision by value
  entry_point 'F_ABS' Module_Name 'FUN.DLL';

/* F_Frac(12.345)=0.345 */
declare external function F_FRAC
  double precision returns double precision by value
  entry_point 'F_FRAC' Module_Name 'FUN.DLL';

declare external function F_ROUND
  double precision returns integer by value
  entry_point 'F_ROUND' Module_Name 'FUN.DLL';

declare external function F_TRUNC
  double precision returns integer by value
  entry_point 'F_TRUNC' Module_Name 'FUN.DLL';

/*
  F_RoundBy(2.35,3,0)=3;    UpRound=3      0 -> to 0 integer
  F_RoundBy(2.51,1,0)=2;    DownRound=1
  F_RoundBy(2.51,2,0)=3;    NaturalRound=2
  F_RoundBy(2.35,3,-1)=10;  UpRound       -1 -> to 10 ten
  F_RoundBy(2.35,3,1)=2.4;  UpRound        1 -> to 0.1 -> 1 decimals
  F_RoundBy(2.354,3,2)=2.36; UpRound       1 -> to 0.01 -> 2 decimals
*/
declare external function F_ROUNDBY
  double precision, integer, integer returns double precision by value
  entry_point 'F_ROUNDBY' Module_Name 'FUN.DLL';

/* convert dec.integer to base: F_NumX(3,2)='11'; F_NUM(255,16)='FF' */
declare external function F_NUMX
  integer, integer returns CString(254)
  entry_point 'F_NUMX' Module_Name 'FUN.DLL';

/* F_XNum('FF',16)=255 */
declare external function F_XNUM
  CString(254),integer returns integer by value
  entry_point 'F_XNUM' Module_Name 'FUN.DLL';

/* a^b ;  F_Power(3,3)=27 (3*3*3)   */
/*        F_Power(4, 0.5)=2  (sqrt) */
declare external function F_POWER
  double precision, double precision returns double precision by value
  entry_point 'F_POWER' Module_Name 'FUN.DLL';

/* Convert string to number */
declare external function F_NUM
  CString(254) returns double precision by value
  entry_point 'F_NUM' Module_Name 'FUN.DLL';

/* Convert number to string */
declare external function F_STR
  double precision returns CString(254)
  entry_point 'F_STR' Module_Name 'FUN.DLL';

declare external function F_REGKEY
  integer,CString(254),CString(254) returns CString(254)
  entry_point 'F_REGKEY' Module_Name 'FUN.DLL';

declare external function F_SN
  returns integer
  entry_point 'F_SN' Module_Name 'FUN.DLL';

commit;

declare external function F_VALHU
  double precision
  returns CString(80)
  entry_point 'F_VALHU' Module_Name 'VALTO.DLL';

commit;

CREATE EXCEPTION "ENONE"  'DbErr1: A record technikai s nem mdosthat (SYSTEM)';
CREATE EXCEPTION "ETOTAL" 'DbErr2: A Ft s DEV sszegek nem mdosthatk az sszevezets miatt';
CREATE EXCEPTION "ETETEL" 'DbErr3: A fasszeg nem mdosthat az FA-zrs miatt';
CREATE EXCEPTION "EAFA"   'DbErr4: A bizonylat fartke nem mdosthat az FA-zrs miatt';
CREATE EXCEPTION "EOSDEV" 'DbErr5: Ms devizanemek az sszevezetsnl';
CREATE EXCEPTION "EUSR"   'DbErr6: A megadott USER nv nem megengedett (SYSTEM,TRSYS)';
CREATE EXCEPTION "EOSK"   'DbErr7: Az rfolyamklmbzeti kartonok nincsenek kijellve (1 es 2)';
CREATE EXCEPTION "EAR"    'DbErr8: Az rfolyamklmbzeti ttel vdett az sszevezets miatt';

commit;

CREATE DOMAIN "D_COMPLET" AS CHAR(1) CHARACTER SET WIN1250
	 default 'N' check(value in ('Y','N','E')) NOT NULL;
CREATE DOMAIN "D_EV" AS  NUMERIC(7,1) default 0 NOT NULL;
CREATE DOMAIN "D_IRANY" AS CHAR(1) CHARACTER SET WIN1250
	 default 'T' check(value in ('T','K')) NOT NULL;
CREATE DOMAIN "D_JELLEG" AS CHAR(1) CHARACTER SET WIN1250
	 default 'S' check(value in ('S','J','B','K','X')) NOT NULL;
CREATE DOMAIN "D_KARTON" AS VARCHAR(16) CHARACTER SET WIN1250
	 default '' NOT NULL COLLATE PXW_HUNDC;
CREATE DOMAIN "D_MOD" AS CHAR(1) CHARACTER SET WIN1250
	 default 'V' check(value in ('V','S','P','B','X','N')) NOT NULL;
CREATE DOMAIN "D_UG" AS CHAR(1) CHARACTER SET WIN1250
	 default 'V' check(value in ('V','S','U','v','s','u')) NOT NULL;
CREATE DOMAIN "D_NY" AS CHAR(1) CHARACTER SET WIN1250
	 default 'N' check(value in ('N','Y')) NOT NULL;
CREATE DOMAIN "D_STATUS" AS CHAR(1) CHARACTER SET WIN1250
	 default 'N' check(value in ('N','R','Z','E')) NOT NULL;
CREATE DOMAIN "D_TYP" AS CHAR(1) CHARACTER SET WIN1250
	 default 'X' check(value in ('X','x','V','v','S','s','T','t','K','k','B','b','P','p','N','1','2','3','4','Z','z')) NOT NULL;
CREATE DOMAIN "D_USER" AS VARCHAR(9) CHARACTER SET WIN1250
	 default '' COLLATE PXW_HUNDC;
CREATE DOMAIN "D_YN" AS CHAR(1) CHARACTER SET WIN1250
	 default 'Y' check(value in ('N','Y')) NOT NULL;
CREATE DOMAIN "D_OS_ID" AS INTEGER default 1 check(value>0) NOT NULL;
CREATE DOMAIN "D_NYELV" AS VARCHAR(1) CHARACTER SET WIN1250
	 default '' check(value in ('','E','D')) NOT NULL;

commit;


/* Table: AFA, Owner: SYSDBA */
CREATE TABLE "VERSION"
( "VE_NUM"    VARCHAR(4) default '0100' NOT NULL,
  "VE_TIME"	  TIMESTAMP default 'now',
 PRIMARY KEY ("VE_NUM")
);

CREATE TABLE "EVZAR"
( "EV_NEV"     VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "EV_SOR"     NUMERIC(14,5) default 0 NOT NULL,
  "EV_A"       VARCHAR(250) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "EV_B"       VARCHAR(40) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "EV_SEGED"   NUMERIC(14,4) default 0,
  "EV_FLAG"    INTEGER default 0,
  "EV_US_NEV"	 "D_USER" COLLATE PXW_HUNDC,
  "EV_TIME"	   TIMESTAMP default 'now',
  PRIMARY KEY ("EV_NEV","EV_SOR")
);

CREATE TABLE "CALC"
(
  CA_OWNER     "D_USER" NOT NULL,
  CA_ID        INTEGER default 0 NOT NULL,
  CA_T         NUMERIC(18,5) default 0 NOT NULL,
  CA_K         NUMERIC(18,5) default 0 NOT NULL,
  PRIMARY KEY (CA_OWNER,CA_ID)
);

CREATE TABLE "FELAFA"
(
  FA_FELADO   VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  FA_FELAFA   VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  FA_AF_NEV   VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  FA_AF_DEV   VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  FA_US_NEV   "D_USER" COLLATE PXW_HUNDC,
  FA_TIME     TIMESTAMP default 'now',
  PRIMARY KEY (FA_FELADO,FA_FELAFA)
);

CREATE TABLE "FELCSOP"
(
  CS_CSOPORT  VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  CS_KARTON   "D_KARTON",
  CS_ELLEN    "D_KARTON",
  CS_US_NEV   "D_USER" COLLATE PXW_HUNDC,
  CS_TIME     TIMESTAMP default 'now',
  PRIMARY KEY (CS_CSOPORT)
);

CREATE TABLE "DEVIZA"
(
  DE_NAME  VARCHAR(3) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  DE_KURZ  NUMERIC(16, 6) default 1 NOT NULL,
  DE_DATE  DATE NOT NULL,
  PRIMARY KEY ("DE_NAME","DE_DATE")
);

CREATE TABLE "BEALL"
( "BE_NEV"      VARCHAR(40) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "BE_TAG"      INTEGER default 0 NOT NULL,
  "BE_OK"       "D_NY",
  "BE_STR"      VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "BE_NUM"      NUMERIC(18,5) default 0 NOT NULL,
  "BE_DAT"	    TIMESTAMP default 'now',
  "BE_EV"       "D_EV",
  "BE_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "BE_TIME"	TIMESTAMP default 'now',
  PRIMARY KEY ("BE_NEV","BE_TAG","BE_EV")
);


CREATE TABLE "NAPLO"
(
  "NA_TYP"      "D_MOD",
  "NA_NO"	INTEGER default 1 NOT NULL,
  "NA_T"        NUMERIC(16, 2) default 0 NOT NULL,
  "NA_K"        NUMERIC(16, 2) default 0 NOT NULL,
  "NA_E"        NUMERIC(16, 2) default 0 NOT NULL,
  "NA_RECNO"    INTEGER default 0 not NULL,
  "NA_OWNER"	"D_USER" COLLATE PXW_HUNDC,
  "NA_FE_ID"	INTEGER default 0 NOT NULL,
  "NA_TIME"	TIMESTAMP default 'now',
  "NA_EV"       "D_EV",
  "NA_STATUS"   "D_STATUS",
 PRIMARY KEY ("NA_TYP","NA_EV","NA_NO")
);

CREATE TABLE "IDOZAR"
( "ID_TELJESIT"	DATE default 'now' NOT NULL,
  "ID_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "ID_TIME"	   TIMESTAMP default 'now',
  "ID_EV"      "D_EV",
 PRIMARY KEY ("ID_TELJESIT","ID_EV")
);


CREATE TABLE "AFA"
(
  "AF_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_KOTELES"	"D_YN",
  "AF_ERTEK"	INTEGER default 0 NOT NULL,
  "AF_ALAP"     "D_NY",
  "AF_PRINT"    INTEGER default 0 NOT NULL,
  "AF_LEIRAS"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "AF_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "AF_TIME"	TIMESTAMP default 'now',
  "AF_EV"	"D_EV" NOT NULL,
  "AF_VT466"	VARCHAR(16) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_BK467"	VARCHAR(16) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_ACSOP"    VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_BCSOP"    VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_CCSOP"    VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AF_XCSOP"    VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
 PRIMARY KEY ("AF_NEV","AF_EV")
);

CREATE TABLE "AFAZAR"
(
  "AZ_ID"       INTEGER default 0 NOT NULL,
  "AZ_CO_ID"    INTEGER default 0 NOT NULL,
  "AZ_ALAP"     NUMERIC(16, 2) default 0 NOT NULL,
  "AZ_AFA"      NUMERIC(16, 2) default 0 NOT NULL,
  "AZ_KEREK"    NUMERIC(16, 2) default 0 NOT NULL,
  "AZ_IDOSZAK"  VARCHAR(50) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "AZ_TIME"	TIMESTAMP default 'now' NOT NULL,
  "AZ_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "AZ_EV"	"D_EV" NOT NULL,
 PRIMARY KEY ("AZ_ID")
);

/* Table: CONTIR, Owner: SYSDBA */

CREATE TABLE "CONTIR"
(
  "CO_ID"	INTEGER default 0 NOT NULL,
  "CO_FE_ID"	INTEGER default 0 NOT NULL,
  "CO_MO_CHAR"	"D_MOD",
  "CO_FE_NAPLO"	INTEGER default 0 NOT NULL,
  "CO_TE_ID"	INTEGER default 0 NOT NULL,
  "CO_FO_KARTON"	"D_KARTON",
  "CO_IRANY"	"D_IRANY",
  "CO_OSSZEG"	NUMERIC(16, 2) default 0 NOT NULL,
  "CO_T"	NUMERIC(16, 2) default 0 NOT NULL,
  "CO_K"	NUMERIC(16, 2) default 0 NOT NULL,
  "CO_STATUS"	"D_STATUS",
  "CO_US_NEV"	"D_USER",
  "CO_TIME"	TIMESTAMP default 'now',
  "CO_EV"	"D_EV",    /* NULL */
  "CO_GY_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "CO_TELJESIT"  DATE default 'now',
  "CO_HATARIDO"  DATE default 'now',
  "CO_KELTE"     DATE default 'now',
  "CO_AFAALAP"   NUMERIC(16, 2) default 0 NOT NULL,
  "CO_AT"        NUMERIC(16, 2) default 0 NOT NULL,
  "CO_AK"        NUMERIC(16, 2) default 0 NOT NULL,
  "CO_AF_NEV"	 VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "CO_AZ_ID"     INTEGER default 0 NOT NULL,
  "CO_UG_ID"     INTEGER default 0 NOT NULL,
  "CO_KO_NEV"   VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "CO_MU_NEV"   VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "CO_ERR"      INTEGER default 0 NOT NULL,
  "CO_ARANYOS"  "D_NY",
 PRIMARY KEY ("CO_ID")
);

/* Table: FEJLEC, Owner: SYSDBA */

CREATE TABLE "FEJLEC"
(
  "FE_ID"	INTEGER default 0 NOT NULL,
  "FE_MO_CHAR"	"D_MOD",
  "FE_NAPLO"	INTEGER default 0,
  "FE_JELLEG"	"D_JELLEG",
  "FE_UG_ID"	INTEGER default 0 NOT NULL,
  "FE_BIZONYLAT"	VARCHAR(16) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_HIVATKOZ"	VARCHAR(16) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_KARTON"	"D_KARTON" COLLATE PXW_HUNDC,
  "FE_TOTAL"	NUMERIC(16, 2) default 0 NOT NULL,
  "FE_AFATOTAL"	NUMERIC(16, 2) default 0 NOT NULL,
  "FE_DEVTOTAL"	NUMERIC(16, 2) default 0 NOT NULL,
  "FE_SUMAR"     NUMERIC(16, 2) default 0 NOT NULL,
  "FE_DEVKURZ"	NUMERIC(16, 6) default 1 NOT NULL,
  "FE_DEV"	VARCHAR(3) CHARACTER SET WIN1250 default '',
  "FE_KELTE"	DATE default 'now' NOT NULL,
  "FE_PENZUGY"  VARCHAR(50) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_MEGJEGY"  VARCHAR(250) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_TELJESIT"	DATE default 'now' NOT NULL,
  "FE_HATARIDO"	DATE default 'now' NOT NULL,
  "FE_FUZMOD"	VARCHAR(16) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_RENDEL"	VARCHAR(16) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_IRANY"	"D_IRANY",
  "FE_MARAD"	NUMERIC(16, 2) default 0 NOT NULL,
  "FE_AFAMARAD"	NUMERIC(16, 2) default 0 NOT NULL,
  "FE_STATUS"	"D_STATUS",
  "FE_ZARAS"	DATE default 'now',
  "FE_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "FE_TIME"	TIMESTAMP default 'now',
  "FE_KIEGY"	NUMERIC(16, 2) default 0,
  "FE_KIEGY2"	NUMERIC(16, 2) default 0,
  "FE_KESES"	INTEGER default 0,
  "FE_OSMOD"    INTEGER default 0,
  "FE_OSMOD2"   INTEGER default 0,
  "FE_EV"	"D_EV" NOT NULL,
  "FE_GY_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_AZ_ID"    INTEGER default 0 NOT NULL,
  "FE_ERR"      INTEGER default 0 NOT NULL,
  "FE_ERROR"    VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_NYOMSZAM"  VARCHAR(16) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FE_REBUILD" integer default 0,
 PRIMARY KEY ("FE_ID")
);


/* Table: FOKONYV, Owner: SYSDBA */

CREATE TABLE "FOKONYV"
(
  "FO_KARTON"	"D_KARTON",
  "FO_TYP"	"D_TYP",
  "FO_COMPLET"	"D_COMPLET",
  "FO_HASZNAL"  "D_YN",
  "FO_MEGNEV"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FO_MEGNEV_E"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FO_MEGNEV_D"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FO_NOTICE"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FO_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "FO_TIME"	TIMESTAMP default 'now',
  "FO_T"	NUMERIC(16, 2) default 0, /* elozoEvi, nyito */
  "FO_K"	NUMERIC(16, 2) default 0, /* elozoEvi, nyito */
  "FO_RT"	NUMERIC(16, 2) default 0, /* E+R+Z */
  "FO_RK"	NUMERIC(16, 2) default 0,
  "FO_NT"	NUMERIC(16, 2) default 0, /* N - nyitott */
  "FO_NK"	NUMERIC(16, 2) default 0,
  "FO_EV"       "D_EV" NOT NULL,
 PRIMARY KEY ("FO_KARTON","FO_EV")
);

CREATE TABLE "FC"
(
  "FC_US_NEV"	"D_USER" NOT NULL COLLATE PXW_HUNDC,
  "FC_KARTON"	"D_KARTON",
  "FC_TYP"	"D_TYP",
  "FC_COMPLET"	"D_COMPLET",
  "FC_HASZNAL"  "D_YN",
  "FC_MEGNEV"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FC_MEGNEV_E"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FC_MEGNEV_D"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "FC_T"	NUMERIC(16, 2) default 0,
  "FC_K"	NUMERIC(16, 2) default 0,
  "FC_E"	NUMERIC(16, 2) default 0,
  "FC_ET"	NUMERIC(16, 2) default 0,  /*elozoevi*/
  "FC_EK"	NUMERIC(16, 2) default 0,  /*elozoevi*/
  "FC_EE"	NUMERIC(16, 2) default 0,  /*elozoevi*/
 PRIMARY KEY ("FC_US_NEV","FC_KARTON")
);

CREATE TABLE "MERLEG"
(
  "ME_ID"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "ME_SOR"	NUMERIC(10,4) default 0 NOT NULL,
  "ME_MEGNEV"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "ME_MEGNEV_E"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "ME_MEGNEV_D"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "ME_CALC"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "ME_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "ME_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("ME_ID","ME_SOR")
);

CREATE TABLE "MC"
(
  "MC_US_NEV"	"D_USER" NOT NULL COLLATE PXW_HUNDC,
  "MC_ID"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "MC_SOR"	NUMERIC(10,4) default 0 NOT NULL,
  "MC_MEGNEV"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MC_MEGNEV_E"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MC_MEGNEV_D"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MC_CALC"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MC_T"	NUMERIC(16, 2) default 0,
  "MC_K"	NUMERIC(16, 2) default 0,
  "MC_E"	NUMERIC(16, 2) default 0,
  "MC_ET"	NUMERIC(16, 2) default 0,  /*elozoevi*/
  "MC_EK"	NUMERIC(16, 2) default 0,  /*elozoevi*/
  "MC_EE"	NUMERIC(16, 2) default 0,  /*elozoevi*/
 PRIMARY KEY ("MC_US_NEV","MC_ID","MC_SOR")
);

/* Table: GYUJTO, Owner: SYSDBA */

CREATE TABLE "GYUJTO"
(
  "GY_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "GY_LEIRAS"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "GY_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "GY_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("GY_NEV")
);

CREATE TABLE "KOLTSEG"
(
  "KO_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "KO_LEIRAS"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "KO_LEIRAS_E"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "KO_LEIRAS_D"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "KO_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "KO_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("KO_NEV")
);

CREATE TABLE "MUNKASZAM"
(
  "MU_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "MU_LEIRAS"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MU_LEIRAS_E"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MU_LEIRAS_D"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MU_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "MU_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("MU_NEV")
);

/* Table: JELLEG, Owner: SYSDBA */

CREATE TABLE "JELLEG"
(
  "JE_CHAR"	"D_JELLEG",
  "JE_MEGNEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "JE_MOD"	VARCHAR(9) CHARACTER SET WIN1250 default 'VSPBX' NOT NULL,
  "JE_IRANY"	VARCHAR(9) CHARACTER SET WIN1250 default 'TKXXX' NOT NULL,
  "JE_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "JE_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("JE_CHAR")
);

/* Table: JOGOK, Owner: SYSDBA */

CREATE TABLE "JOGOK"
(
  "JO_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "JO_LEIRAS"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "JO_MENU"	VARCHAR(254) CHARACTER SET WIN1250 default '',
  "JO_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "JO_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("JO_NEV")
);

/* Table: LOGINS, Owner: SYSDBA */

CREATE TABLE "LOGINS"
(
  "LO_US_NEV"	"D_USER" NOT NULL,
  "LO_TIME"	TIMESTAMP default 'now',
  "LO_IP"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "LO_SN"	VARCHAR(40) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "LO_JO_MENU"  VARCHAR(254) CHARACTER SET WIN1250 default '',
  "LO_EV"	"D_EV" NOT NULL,
 PRIMARY KEY ("LO_US_NEV")
);

/* Table: MODOZAT, Owner: SYSDBA */

CREATE TABLE "MODOZAT"
(
  "MO_CHAR"	"D_MOD",
  "MO_MEGNEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MO_US_NEV"	VARCHAR(9) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "MO_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("MO_CHAR")
);

/* Table: OSSZEPONT, Owner: SYSDBA */

CREATE TABLE "OSSZEPONT"
(
  "OS_ID"	INTEGER default 0 NOT NULL,
  "OS_FE_ID_A"	"D_OS_ID",
  "OS_FE_ID_B"	"D_OS_ID",
  "OS_SUMA"	NUMERIC(16, 2) default 0 NOT NULL,
  "OS_DEV"      VARCHAR(3) CHARACTER SET WIN1250 default '',
  "OS_KESES"    INTEGER default 0 NOT NULL,
  "OS_12"       NUMERIC(16, 2) default 0 NOT NULL,
  "OS_FEID"     INTEGER default 0 NOT NULL,
  "OS_MOD"      INTEGER default 0 NOT NULL,
  "OS_US_NEV"	"D_USER",
  "OS_TIME"	TIMESTAMP default 'now',
  "OS_EV"       "D_EV",        /* NULL */
 PRIMARY KEY ("OS_ID")
);

/* Table: SABLON, Owner: SYSDBA */

CREATE TABLE "SABLON"
(
  "SA_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "SA_LEIRAS"	VARCHAR(127) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "SA_ELLEN"	"D_KARTON" COLLATE PXW_HUNDC,
  "SA_AFASZAMLA"	"D_KARTON" COLLATE PXW_HUNDC,
  "SA_AF_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "SA_ATVEZ1"	"D_KARTON" COLLATE PXW_HUNDC,
  "SA_ATVEZ2"	"D_KARTON" COLLATE PXW_HUNDC,
  "SA_GY_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "SA_MEGJEGY"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "SA_MEGJEGY_E" VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "SA_MEGJEGY_D" VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "SA_KO_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "SA_MU_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "SA_ARANYOS"  "D_YN",
  "SA_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "SA_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("SA_NEV")
);

/* Table: TETEL, Owner: SYSDBA */

CREATE TABLE "TETEL"
(
  "TE_ID"	INTEGER default 0 NOT NULL,
  "TE_FE_ID"	INTEGER default 0 NOT NULL,
  "TE_FE_IRANY"	"D_IRANY",
  "TE_ELLEN"	"D_KARTON",
  "TE_AFASZAMLA" "D_KARTON",
  "TE_ATVEZ1"	"D_KARTON",
  "TE_ATVEZ2"	"D_KARTON",
  "TE_SUM"	NUMERIC(16, 2) default 0 NOT NULL,
  "TE_AFASUM"	NUMERIC(16, 2) default 0 NOT NULL,
  "TE_SA_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "TE_GY_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "TE_AF_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "TE_AF_ERTEK"	INTEGER default 0 NOT NULL,
  "TE_MEGJEGY"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "TE_MEGJEGY_E" VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "TE_MEGJEGY_D" VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "TE_FE_STATUS" "D_STATUS",
  "TE_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "TE_TIME"	TIMESTAMP default 'now',
  "TE_EV"	"D_EV",      /* NULL*/
  "TE_KO_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "TE_MU_NEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "TE_ERR"      INTEGER default 0 NOT NULL,
  "TE_ERROR"    VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "TE_ARANYOS"  "D_NY",
 PRIMARY KEY ("TE_ID")
);

/* Table: TIPUS, Owner: SYSDBA */

CREATE TABLE "TIPUS"
(
  "TI_TYP"	"D_TYP",
  "TI_MEGNEV"	VARCHAR(60) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "TI_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "TI_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("TI_TYP")
);

/* Table: TMEMOK, Owner: SYSDBA */

CREATE TABLE "TMEMOK"
(
  "TM_TBL"	CHAR(2) CHARACTER SET WIN1250 default'' NOT NULL,
  "TM_RECID"	INTEGER default 0 NOT NULL,
  "TM_SOR"	INTEGER default 0 NOT NULL,
  "TM_TXT"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
 PRIMARY KEY ("TM_TBL", "TM_RECID")
);

/* Table: UGYFEL, Owner: SYSDBA */

CREATE TABLE "UGYFEL"
(
  "UG_ID"       INTEGER default 0 NOT NULL,
  "UG_ROVID"	VARCHAR(15) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "UG_MOD"	"D_TYP",
  "UG_KARTON"   "D_KARTON",
  "UG_CEG"	VARCHAR(60) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "UG_KATEG"	VARCHAR(31) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "UG_HELY"	VARCHAR(31) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "UG_IRSZ"	VARCHAR(9) CHARACTER SET WIN1250 default '',
  "UG_UTCA"	VARCHAR(61) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "UG_ADOSZAM"	VARCHAR(31) CHARACTER SET WIN1250 default '',
  "UG_BANKSZAM"	VARCHAR(61) CHARACTER SET WIN1250 default '',
  "UG_TEL"	VARCHAR(20) CHARACTER SET WIN1250 default '',
  "UG_MOBIL"	VARCHAR(20) CHARACTER SET WIN1250 default '',
  "UG_FAX"	VARCHAR(20) CHARACTER SET WIN1250 default '',
  "UG_EMAIL"	VARCHAR(61) CHARACTER SET WIN1250 default '',
  "UG_EGYEB"	VARCHAR(254) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "UG_NYELV"    "D_NYELV",
  "UG_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "UG_TIME"	TIMESTAMP default 'now',
  "UG_T"	NUMERIC(16, 2) default 0,  /* E elozoevi ami a nyito */
  "UG_K"	NUMERIC(16, 2) default 0,
  "UG_RT"	NUMERIC(16, 2) default 0,  /* R+Z+E  minden */
  "UG_RK"	NUMERIC(16, 2) default 0,
  "UG_NT"	NUMERIC(16, 2) default 0,  /* N  - nyitott munka */
  "UG_NK"	NUMERIC(16, 2) default 0,
  "UG_EV"       "D_EV" NOT NULL,
 PRIMARY KEY ("UG_ID","UG_EV","UG_KARTON")
);

/* Table: USR, Owner: SYSDBA */

CREATE TABLE "USR"
(
  "US_NEV"	"D_USER" NOT NULL,
  "US_VNEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "US_KNEV"	VARCHAR(30) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "US_PWD"	VARCHAR(9) CHARACTER SET WIN1250 default '' NOT NULL COLLATE PXW_HUNDC,
  "US_JO_NEV"	VARCHAR(20) CHARACTER SET WIN1250 default '' COLLATE PXW_HUNDC,
  "US_US_NEV"	"D_USER" COLLATE PXW_HUNDC,
  "US_TIME"	TIMESTAMP default 'now',
 PRIMARY KEY ("US_NEV")
);

/*  Index definitions for all user tables */

CREATE UNIQUE INDEX "OS_1" ON "OSSZEPONT"("OS_FE_ID_A", "OS_FE_ID_B");
CREATE UNIQUE INDEX "OS_2" ON "OSSZEPONT"("OS_FE_ID_B", "OS_FE_ID_A");
CREATE UNIQUE INDEX "UG_1" ON "UGYFEL"("UG_ROVID","UG_EV","UG_KARTON");
CREATE INDEX "UG_2" ON "UGYFEL"("UG_CEG");
CREATE UNIQUE INDEX "ALFA" ON "UGYFEL"("UG_ID","UG_EV");
CREATE INDEX "FE_1" ON "FEJLEC"("FE_BIZONYLAT");
CREATE INDEX "FE_2" ON "FEJLEC"("FE_HIVATKOZ");
CREATE INDEX "CO_1" ON "CONTIR"("CO_TELJESIT");
CREATE INDEX "CO_2" ON "CONTIR"("CO_FE_ID");
CREATE INDEX "CO_3" ON "CONTIR"("CO_UG_ID","CO_TELJESIT");
CREATE INDEX "CO_4" ON "CONTIR"("CO_FO_KARTON","CO_TELJESIT");

CREATE GENERATOR "CO";
CREATE GENERATOR "FE";
CREATE GENERATOR "OS";
CREATE GENERATOR "TE";
CREATE GENERATOR "UG";
CREATE GENERATOR "AZ";

commit;

SET TERM ^ ;

CREATE PROCEDURE OS_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(OS,1);
END
^

CREATE PROCEDURE CO_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(CO,1);
END
^

CREATE PROCEDURE TE_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(TE,1);
END
^

CREATE PROCEDURE FE_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(FE,1);
END
^

CREATE PROCEDURE UG_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(UG,1);
END
^
CREATE PROCEDURE AZ_NEXT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(AZ,1);
END
^


/*-------------------*/

CREATE PROCEDURE OS_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(OS,0);
END
^

CREATE PROCEDURE CO_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(CO,0);
END
^

CREATE PROCEDURE TE_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(TE,0);
END
^

CREATE PROCEDURE FE_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(FE,0);
END
^


CREATE PROCEDURE UG_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(UG,0);
END
^

CREATE PROCEDURE AZ_ACT
RETURNS (G INTEGER)
AS
BEGIN
  G=gen_id(AZ,0);
END
^

/********** FEJLEC *************/

CREATE TRIGGER FEJLEC_BD FOR FEJLEC BEFORE DELETE POSITION 0 AS
DECLARE VARIABLE T date;
BEGIN
  if ((Old.FE_AZ_ID>0) and (Old.FE_AFATOTAL<>0)) then EXCEPTION EAFA;
  if (Old.FE_OSMOD2=1) then EXCEPTION EAR;
END^

CREATE TRIGGER FEJLEC_AD FOR FEJLEC
  AFTER DELETE POSITION 0 AS
BEGIN
  delete from TETEL where TE_FE_ID=Old.FE_ID;
  delete from CONTIR where CO_FE_ID=Old.FE_ID;
  delete from OSSZEPONT where OS_FE_ID_A=OLD.FE_ID or OS_FE_ID_B=OLD.FE_ID;
  update NAPLO set NA_RECNO=NA_RECNO-1 where NA_NO=OLD.FE_NAPLO and NA_EV=OLD.FE_EV and NA_TYP=OLD.FE_MO_CHAR and NA_RECNO>0;
END^


CREATE TRIGGER FEJLEC_BI FOR FEJLEC BEFORE INSERT POSITION 0 AS
DECLARE VARIABLE A integer;
DECLARE VARIABLE T date;
BEGIN
  New.FE_TIME='now';
  New.FE_AZ_ID=0;
  if (New.FE_KESES is NULL) then New.FE_KESES=0;
  if (New.FE_OSMOD is NULL) then New.FE_OSMOD=0;
  if (New.FE_OSMOD2 is NULL) then New.FE_OSMOD2=0;
  if (New.FE_DEVTOTAL is NULL) then New.FE_DEVTOTAL=0;
  if ((New.FE_DEV is NULL) or (New.FE_DEV<' ')) then New.FE_DEV='';
  if (New.FE_DEV>' ')  then begin
    New.FE_SUMAR=New.FE_DEVTOTAL;
  end else begin
    New.FE_SUMAR=New.FE_TOTAL;
  end
  if (New.FE_AFATOTAL is NULL) then New.FE_AFATOTAL=0;
  if ((NEW.FE_MO_CHAR='B') or
      (NEW.FE_MO_CHAR='P') or
      (NEW.FE_MO_CHAR='N') or
      (NEW.FE_MO_CHAR='X'))
  then begin
     NEW.FE_TELJESIT=NEW.FE_KELTE;
     NEW.FE_HATARIDO=NEW.FE_KELTE;
  end
  if ((NEW.FE_MO_CHAR='N') and (New.FE_STATUS='N')) then New.FE_STATUS='R';
  if (New.FE_KIEGY is NULL) then New.FE_KIEGY=0;
  if (New.FE_KIEGY2 is NULL) then New.FE_KIEGY2=0;
  if (New.FE_GY_NEV is NULL) then New.FE_GY_NEV='';
END^


CREATE TRIGGER FEJLEC_BU FOR FEJLEC BEFORE UPDATE POSITION 0 AS
 DECLARE VARIABLE A integer;
 DECLARE VARIABLE T date;
BEGIN
  if (NEW.FE_US_NEV='REBUILD') then begin
     NEW.FE_REBUILD=9;
     NEW.FE_US_NEV=OLD.FE_US_NEV;
     New.FE_TIME=OLD.FE_TIME;
  end else begin
     NEW.FE_REBUILD=0;
  end
  if (NEW.FE_REBUILD=0) then begin
    if ((New.FE_AFATOTAL<>OLD.FE_AFATOTAL) and (Old.FE_AZ_ID>0)) then begin
      EXCEPTION EAFA;
    end
    if ((New.FE_TOTAL<>OLD.FE_TOTAL) or (New.FE_DEV<>Old.FE_DEV) or (New.FE_DEVTOTAL<>OLD.FE_DEVTOTAL) or (New.FE_DEVKURZ<>Old.FE_DEVKURZ) ) then begin
      A=0;
      select COUNT(*) from OSSZEPONT where OS_FE_ID_A=New.FE_ID or OS_FE_ID_B=New.FE_ID or OS_FEID=New.FE_ID into :A ;
      if (A>0) then begin
        EXCEPTION ETOTAL;
      end
    end
    if ((NEW.FE_MO_CHAR='B') or
        (NEW.FE_MO_CHAR='P') or
        (NEW.FE_MO_CHAR='N') or
        (NEW.FE_MO_CHAR='X'))
    then begin
       NEW.FE_TELJESIT=NEW.FE_KELTE;
       NEW.FE_HATARIDO=NEW.FE_KELTE;
    end
    if ((NEW.FE_MO_CHAR='N') and (New.FE_STATUS='N')) then New.FE_STATUS='R';
    if (NEW.FE_US_NEV='TRSYS') then begin
      New.FE_TIME=OLD.FE_TIME;
      NEW.FE_US_NEV=Old.FE_US_NEV;
    end else begin
      New.FE_TIME='now';
    end
    if (New.FE_KIEGY is NULL) then New.FE_KIEGY=0;
    if (New.FE_KESES is NULL) then New.FE_KESES=0;
    if (New.FE_GY_NEV is NULL) then New.FE_GY_NEV='';
    New.FE_GY_NEV=F_TRIM(New.FE_GY_NEV);
    if (New.FE_DEV>' ') then begin
      New.FE_SUMAR=New.FE_DEVTOTAL;
    end else begin
      New.FE_SUMAR=New.FE_TOTAL;
    end
  end
END^


CREATE TRIGGER FEJLEC_AU FOR FEJLEC
  AFTER UPDATE POSITION 0 AS
 DECLARE VARIABLE A integer;
begin
  if (New.FE_REBUILD=0) then begin
    delete from CONTIR where CO_FE_ID=Old.FE_ID and CO_TE_ID=0;
    A=GEN_ID(CO,1);
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV, CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_ERR)
     VALUES (NEW.FE_EV,:A, New.FE_ID, NEW.FE_MO_CHAR,NEW.FE_NAPLO,0,NEW.FE_KARTON,NEW.FE_IRANY, NEW.FE_TOTAL,NEW.FE_STATUS,NEW.FE_US_NEV,'now',NEW.FE_GY_NEV,NEW.FE_TELJESIT,NEW.FE_HATARIDO,NEW.FE_KELTE,NEW.FE_UG_ID,0,'',New.FE_AZ_ID,New.FE_ERR);
    if ((New.FE_TELJESIT<>Old.FE_TELJESIT) or (New.FE_HATARIDO<>Old.FE_HATARIDO)) then begin
      update OSSZEPONT set OS_KESES=0 where OS_FE_ID_A=New.FE_ID or OS_FE_ID_B=New.FE_ID;
    end
    if (NEW.FE_STATUS<>OLD.FE_STATUS)  then begin
      update TETEL set TE_FE_STATUS=NEW.FE_STATUS, TE_US_NEV='TRSYS' where TE_FE_ID=New.FE_ID ;
    end
    if ((NEW.FE_STATUS<>OLD.FE_STATUS) or (NEW.FE_TELJESIT<>OLD.FE_TELJESIT) or (New.FE_KELTE<>Old.FE_KELTE) or (NEW.FE_HATARIDO<>OLD.FE_HATARIDO))   then begin
      update CONTIR set CO_STATUS=NEW.FE_STATUS,CO_TELJESIT=NEW.FE_TELJESIT,CO_HATARIDO=NEW.FE_HATARIDO, CO_KELTE=NEW.FE_KELTE, CO_US_NEV='TRSYS' where CO_FE_ID=New.FE_ID and CO_ID<>:A ;
    end
    if ((OLD.FE_NAPLO<>New.FE_NAPLO) or (Old.FE_MO_CHAR<>New.FE_MO_CHAR)) then begin
      update NAPLO set NA_RECNO=NA_RECNO-1 where NA_NO=Old.FE_NAPLO and NA_EV=OLD.FE_EV and NA_TYP=Old.FE_MO_CHAR;
      update NAPLO set NA_RECNO=NA_RECNO+1 where NA_NO=New.FE_NAPLO and NA_EV=New.FE_EV and NA_TYP=New.FE_MO_CHAR;
      if (ROW_COUNT<=0) then begin
        insert into NAPLO (NA_TYP,NA_EV,NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_FE_ID,NA_TIME,NA_RECNO) VALUES (New.FE_MO_CHAR,New.FE_EV,New.FE_NAPLO,0,0,0,New.FE_US_NEV,New.FE_ID,'now',1);
      end
    end
  end
END^


CREATE TRIGGER FEJLEC_AI FOR FEJLEC
  AFTER INSERT POSITION 0 AS
 DECLARE VARIABLE A integer;
begin
  A=0;
  update NAPLO set NA_RECNO=NA_RECNO+1, NA_FE_ID=New.FE_ID where NA_NO=New.FE_NAPLO and NA_EV=New.FE_EV and NA_TYP=New.FE_MO_CHAR;
  if (ROW_COUNT<=0) then begin
    insert into NAPLO (NA_TYP,NA_EV,NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_FE_ID,NA_TIME,NA_RECNO) VALUES (New.FE_MO_CHAR,New.FE_EV,New.FE_NAPLO,0,0,0,New.FE_US_NEV,NEW.FE_ID,'now',1);
  end
  A=GEN_ID(CO,1); /* Total */
  insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_ERR)
   VALUES (New.FE_EV, :A, New.FE_ID, NEW.FE_MO_CHAR,NEW.FE_NAPLO,0,NEW.FE_KARTON,NEW.FE_IRANY, NEW.FE_TOTAL,NEW.FE_STATUS,NEW.FE_US_NEV,'now',NEW.FE_GY_NEV, New.FE_TELJESIT, NEW.FE_HATARIDO,NEW.FE_KELTE,NEW.FE_UG_ID,0,'',New.FE_ERR);
END^


/********** Tetel *************/

CREATE TRIGGER TETEL_BI FOR TETEL BEFORE INSERT POSITION 0 AS
BEGIN
  New.TE_TIME='now';
  if (New.TE_ELLEN is null) then begin
    NEW.TE_ELLEN='';
  end
  if (New.TE_AFASZAMLA is null) then begin
    NEW.TE_AFASZAMLA='';
  end
  if (New.TE_ATVEZ1 is null) then begin
    NEW.TE_ATVEZ1='';
  end
  if (New.TE_ATVEZ2 is null) then begin
    NEW.TE_ATVEZ2='';
  end
END^

CREATE TRIGGER TETEL_BU FOR TETEL BEFORE UPDATE POSITION 0 AS
BEGIN
  if (NEW.TE_US_NEV='TRSYS') then begin
    New.TE_TIME=OLD.TE_TIME;
    NEW.TE_US_NEV=Old.TE_US_NEV;
  end else begin
    New.TE_TIME='now';
  end
END^

CREATE TRIGGER TETEL_AD FOR TETEL
  AFTER DELETE POSITION 0 AS
BEGIN
  delete from CONTIR where CO_TE_ID=Old.TE_ID;
END^


CREATE TRIGGER TETEL_AU FOR TETEL
  AFTER UPDATE POSITION 0
  AS
  DECLARE VARIABLE A integer;
  DECLARE VARIABLE N integer;
  DECLARE VARIABLE B char(1);
  DECLARE VARIABLE BB char(1);
  DECLARE VARIABLE E char(1);
  DECLARE VARIABLE M char(1);
  DECLARE VARIABLE D NUMERIC(16,2);
  DECLARE VARIABLE U varchar(9);
  DECLARE VARIABLE R NUMERIC(7,1);
  DECLARE VARIABLE D1 TIMESTAMP;
  DECLARE VARIABLE D2 TIMESTAMP;
  DECLARE VARIABLE D3 TIMESTAMP;
  DECLARE VARIABLE UG INTEGER;
  DECLARE VARIABLE AZ INTEGER;
  DECLARE VARIABLE ERR INTEGER;
begin
  delete from CONTIR where CO_TE_ID=Old.TE_ID;

  select FE_EV,FE_IRANY, FE_TOTAL, FE_STATUS, FE_MO_CHAR, FE_NAPLO, FE_US_NEV, FE_TELJESIT, FE_HATARIDO, FE_KELTE, FE_UG_ID,FE_AZ_ID,FE_ERR from FEJLEC where FE_ID=New.TE_FE_ID INTO :R, :B, :D, :E, :M, :N, :U, :D1, :D2, :D3, :UG, :AZ, :ERR ;
  BB='T';
  if (B='T') then BB='K';
  if ((AZ>0) and (New.TE_AFASUM<>Old.TE_AFASUM)) then begin
    EXCEPTION ETETEL;
  end

  A=GEN_ID(CO,1);  /* Ellen */
  insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV, CO_TELJESIT, CO_HATARIDO, CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV,CO_ERR)
  VALUES (:R, :A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ELLEN, :BB, New.TE_SUM, :E, :U, 'now',NEW.TE_GY_NEV, :D1, :D2,:D3,:UG,0,'',:AZ, New.TE_KO_NEV, New.TE_MU_NEV,:ERR);

  if (New.TE_ATVEZ1>'') then begin
    A=GEN_ID(CO,1); /* ATVEZETES 1,2 */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV, CO_TELJESIT, CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV,CO_ERR)
    VALUES (:R,:A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ATVEZ1, :B, New.TE_SUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1,:D2,:D3,:UG,0,'',:AZ, New.TE_KO_NEV, New.TE_MU_NEV,:ERR);
    A=GEN_ID(CO,1); /* ATVEZETES 1,2 */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV, CO_TELJESIT, CO_HATARIDO,CO_KELTE, CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV,CO_ERR)
    VALUES (:R,:A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ATVEZ2, :BB, New.TE_SUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1,:D2,:D3,:UG,0,'',:AZ, New.TE_KO_NEV, New.TE_MU_NEV,:ERR);
  end

  if (F_TRIM(NEW.TE_AFASZAMLA)>'') then begin
    A=GEN_ID(CO,1);  /* AFA */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV,CO_ERR)
    VALUES (:R, :A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_AFASZAMLA, :BB, New.TE_AFASUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1,:D2,:D3,:UG, NEW.TE_SUM,NEW.TE_AF_NEV,:AZ, New.TE_KO_NEV, New.TE_MU_NEV,:ERR);
  end
END^

CREATE TRIGGER TETEL_AI FOR TETEL
  AFTER INSERT POSITION 0
  AS
  DECLARE VARIABLE A integer;
  DECLARE VARIABLE N integer;
  DECLARE VARIABLE B char(1);
  DECLARE VARIABLE BB char(1);
  DECLARE VARIABLE E char(1);
  DECLARE VARIABLE M char(1);
  DECLARE VARIABLE D NUMERIC(16,2);
  DECLARE VARIABLE U varchar(9);
  DECLARE VARIABLE R NUMERIC(7,1);
  DECLARE VARIABLE D1 TIMESTAMP;
  DECLARE VARIABLE D2 TIMESTAMP;
  DECLARE VARIABLE D3 TIMESTAMP;
  DECLARE VARIABLE UG integer;
  DECLARE VARIABLE AZ INTEGER;
  DECLARE VARIABLE ERR INTEGER;
BEGIN
  select FE_EV,FE_IRANY, FE_TOTAL, FE_STATUS, FE_MO_CHAR, FE_NAPLO, FE_US_NEV, FE_TELJESIT,FE_HATARIDO, FE_KELTE, FE_UG_ID, FE_AZ_ID,FE_ERR from FEJLEC where FE_ID=New.TE_FE_ID INTO :R, :B, :D, :E, :M, :N, :U, :D1, :D2, :D3, :UG,:AZ ,:ERR ;
  BB='T';
  if (B='T') then BB='K';
  A=GEN_ID(CO,1);  /* Ellen */
  insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV,CO_ERR)
  VALUES (:R,:A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ELLEN, :BB, New.TE_SUM, :E, :U, 'now', NEW.TE_GY_NEV, :D1,:D2,:D3,:UG, 0,'',:AZ, New.TE_KO_NEV, New.TE_MU_NEV,:ERR);
  if (New.TE_ATVEZ1>'') then begin
    A=GEN_ID(CO,1); /* ATVEZETES 1,2 */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV)
    VALUES (:R, :A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ATVEZ1, :B, New.TE_SUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1,:D2,:D3,:UG, 0, '',:AZ, New.TE_KO_NEV, New.TE_MU_NEV );
    A=GEN_ID(CO,1); /* ATVEZETES 1,2 */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT, CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV)
    VALUES (:R, :A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_ATVEZ2, :BB, New.TE_SUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1,:D2,:D3,:UG, 0, '',:AZ, New.TE_KO_NEV, New.TE_MU_NEV);
  end
  if (F_TRIM(NEW.TE_AFASZAMLA)>'') then begin
    A=GEN_ID(CO,1);  /* AFA */
    insert into CONTIR (CO_EV,CO_ID,CO_FE_ID,CO_MO_CHAR,CO_FE_NAPLO,CO_TE_ID,CO_FO_KARTON,CO_IRANY,CO_OSSZEG,CO_STATUS,CO_US_NEV,CO_TIME,CO_GY_NEV,CO_TELJESIT,CO_HATARIDO,CO_KELTE,CO_UG_ID,CO_AFAALAP,CO_AF_NEV,CO_AZ_ID,CO_KO_NEV,CO_MU_NEV)
    VALUES (:R, :A, New.TE_FE_ID, :M, :N, New.TE_ID, New.TE_AFASZAMLA, :BB, New.TE_AFASUM, :E, :U, 'now',NEW.TE_GY_NEV,:D1, :D2,:D3,:UG, New.TE_SUM, New.TE_AF_NEV,:AZ, New.TE_KO_NEV, New.TE_MU_NEV);
  end
END^

/********** Contir *************/

CREATE TRIGGER CONTIR_BI FOR CONTIR BEFORE INSERT POSITION 0 AS
 DECLARE VARIABLE S char(1);
BEGIN
  New.CO_TIME='now';
  if (New.CO_AZ_ID is NULL) then New.CO_AZ_ID=0;
  if (NEW.CO_IRANY='T') then begin
    New.CO_T=NEW.CO_OSSZEG;
    New.CO_K=0;
    New.CO_AT=New.CO_AFAALAP;
    New.CO_AK=0;
  end else begin
    New.CO_K=NEW.CO_OSSZEG;
    New.CO_T=0;
    New.CO_AK=New.CO_AFAALAP;
    New.CO_AT=0;
  end
END^

CREATE TRIGGER CONTIR_BU FOR CONTIR BEFORE UPDATE POSITION 0 AS
  DECLARE VARIABLE S char(1);
BEGIN
  if (New.CO_AZ_ID is NULL) then New.CO_AZ_ID=0;
  if (NEW.CO_IRANY='T') then begin
    New.CO_T=NEW.CO_OSSZEG;
    New.CO_K=0;
    New.CO_AT=New.CO_AFAALAP;
    New.CO_AK=0;
  end else begin
    New.CO_K=NEW.CO_OSSZEG;
    New.CO_T=0;
    New.CO_AK=New.CO_AFAALAP;
    New.CO_AT=0;
  end
  if (NEW.CO_US_NEV='TRSYS') then begin
    New.CO_TIME=OLD.CO_TIME;
    NEW.CO_US_NEV=Old.CO_US_NEV;
  end else begin
    New.CO_TIME='now';
  end
END^

CREATE TRIGGER CONTIR_AI FOR CONTIR
  AFTER INSERT POSITION 0 AS
DECLARE VARIABLE CNT INTEGER;
BEGIN
 /*** new FO ***/
 if (New.CO_MO_CHAR<>'N') then begin
   if (NEW.CO_STATUS='N') then begin
     if (NEW.CO_IRANY='T') then begin
       update FOKONYV set FO_NT=FO_NT+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
     end else begin
       update FOKONYV set FO_NK=FO_NK+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
     end
   end else begin
     if ((NEW.CO_STATUS='R') or (NEW.CO_STATUS='Z')) then begin
       if (NEW.CO_IRANY='T') then begin
         update FOKONYV set FO_RT=FO_RT+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
       end else begin
         update FOKONYV set FO_RK=FO_RK+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
       end
     end
   end
 end else begin
   if (NEW.CO_IRANY='T') then begin
     update FOKONYV set FO_RT=FO_RT+NEW.CO_OSSZEG, FO_T=FO_T+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
   end else begin
     update FOKONYV set FO_RK=FO_RK+NEW.CO_OSSZEG, FO_K=FO_K+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
   end
 end
/*** new UG ***/
 select COUNT(*) X from UGYFEL where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON into :CNT ;
 if (CNT>0)  then begin
   if (New.CO_STATUS='N') then begin
     if (New.CO_IRANY='T') then begin
       update UGYFEL set UG_NT= UG_NT+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
     end else begin
       update UGYFEL set UG_NK= UG_NK+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
     end
   end else begin
     if ((New.CO_STATUS='R') or (New.CO_STATUS='Z'))  then begin
       if (New.CO_IRANY='T') then begin
         update UGYFEL set UG_RT= UG_RT+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
       end else begin
         update UGYFEL set UG_RK= UG_RK+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
       end
     end else begin
       if (New.CO_STATUS='E') then begin
         if (New.CO_IRANY='T') then begin
           update UGYFEL set UG_RT= UG_RT+New.CO_OSSZEG, UG_T= UG_T+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
         end else begin
           update UGYFEL set UG_RK= UG_RK+New.CO_OSSZEG, UG_K= UG_K+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
         end
       end
     end
   end
 end
 if (New.CO_IRANY='T') then begin
   update NAPLO set NA_T=NA_T+New.CO_OSSZEG, NA_E=NA_E+NEW.CO_OSSZEG where NA_TYP=New.CO_MO_CHAR and NA_NO=New.CO_FE_NAPLO and NA_EV=New.CO_EV;
 end else begin
   update NAPLO set NA_K=NA_K+New.CO_OSSZEG, NA_E=NA_E-NEW.CO_OSSZEG where NA_TYP=New.CO_MO_CHAR and NA_NO=New.CO_FE_NAPLO and NA_EV=New.CO_EV;
 end
END^

CREATE TRIGGER CONTIR_AD FOR CONTIR
  AFTER DELETE POSITION 0 AS
DECLARE VARIABLE CNT INTEGER;
BEGIN
 /*** old FO ***/
 if (Old.CO_MO_CHAR<>'N') then begin
   if (Old.CO_STATUS='N') then begin
     if (Old.CO_IRANY='T') then begin
       update FOKONYV set FO_NT=FO_NT-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
     end else begin
       update FOKONYV set FO_NK=FO_NK-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
     end
   end else begin
     if ((Old.CO_STATUS='R') or (Old.CO_STATUS='Z')) then begin
       if (Old.CO_IRANY='T') then begin
         update FOKONYV set FO_RT=FO_RT-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
       end else begin
         update FOKONYV set FO_RK=FO_RK-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
       end
     end
   end
 end else begin
   /* nyito */
   if (Old.CO_IRANY='T') then begin
     update FOKONYV set FO_RT=FO_RT-Old.CO_OSSZEG, FO_T=FO_T-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
   end else begin
     update FOKONYV set FO_RK=FO_RK-Old.CO_OSSZEG, FO_K=FO_K-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
   end
 end
 /*** old UG ***/
 if (Old.CO_UG_ID>0) then begin
   select COUNT(*) X from UGYFEL where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON into :CNT ;
   if (CNT>0)  then begin
     if (Old.CO_STATUS='N') then begin
       if (Old.CO_IRANY='T') then begin
         update UGYFEL set UG_NT= UG_NT-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
       end else begin
         update UGYFEL set UG_NK= UG_NK-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
       end
     end else begin
       if ((Old.CO_STATUS='R') or (Old.CO_STATUS='Z'))  then begin
         if (Old.CO_IRANY='T') then begin
           update UGYFEL set UG_RT= UG_RT-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
         end else begin
           update UGYFEL set UG_RK= UG_RK-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
         end
       end else begin
         if (Old.CO_STATUS='E') then begin
           if (Old.CO_IRANY='T') then begin
             update UGYFEL set UG_RT= UG_RT-Old.CO_OSSZEG, UG_T= UG_T-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
           end else begin
             update UGYFEL set UG_RK= UG_RK-Old.CO_OSSZEG, UG_K= UG_K-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
           end
         end
       end
     end
   end
 end
 if (Old.CO_IRANY='T') then begin
   update NAPLO set NA_T=NA_T-Old.CO_OSSZEG, NA_E=NA_E-Old.CO_OSSZEG where NA_TYP=Old.CO_MO_CHAR and NA_NO=Old.CO_FE_NAPLO and NA_EV=Old.CO_EV;
 end else begin
   update NAPLO set NA_K=NA_K-Old.CO_OSSZEG, NA_E=NA_E+Old.CO_OSSZEG where NA_TYP=Old.CO_MO_CHAR and NA_NO=Old.CO_FE_NAPLO and NA_EV=Old.CO_EV;
 end
END^

CREATE TRIGGER CONTIR_AU FOR CONTIR
  AFTER UPDATE POSITION 0 AS
DECLARE VARIABLE CNT INTEGER;
BEGIN
  /*** old FO ***/
 if ((Old.CO_UG_ID<>New.CO_UG_ID) or (OLD.CO_OSSZEG<>New.CO_OSSZEG) or (OLD.CO_FO_KARTON<>New.CO_FO_KARTON) or (OLD.CO_STATUS<>New.CO_STATUS)) then begin
   if (Old.CO_MO_CHAR<>'N') then begin
     if (Old.CO_STATUS='N') then begin
       if (Old.CO_IRANY='T') then begin
         update FOKONYV set FO_NT=FO_NT-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
       end else begin
         update FOKONYV set FO_NK=FO_NK-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
       end
     end else begin
       if ((Old.CO_STATUS='R') or (Old.CO_STATUS='Z')) then begin
         if (Old.CO_IRANY='T') then begin
           update FOKONYV set FO_RT=FO_RT-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
         end else begin
           update FOKONYV set FO_RK=FO_RK-Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
         end
       end
     end
   end else begin
      /* nyito */
     if (Old.CO_IRANY='T') then begin
       update FOKONYV set FO_RT=FO_RT-Old.CO_OSSZEG, FO_T=FO_T+Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
     end else begin
       update FOKONYV set FO_RK=FO_RK-Old.CO_OSSZEG, FO_K=FO_K+Old.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=Old.CO_FO_KARTON and FO_EV=Old.CO_EV;
     end
   end
    /*** new FO ***/
   if (New.CO_MO_CHAR<>'N') then begin
     if (NEW.CO_STATUS='N') then begin
       if (NEW.CO_IRANY='T') then begin
         update FOKONYV set FO_NT=FO_NT+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
       end else begin
         update FOKONYV set FO_NK=FO_NK+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
       end
     end else begin
       if ((NEW.CO_STATUS='R') or (NEW.CO_STATUS='Z')) then begin
         if (NEW.CO_IRANY='T') then begin
           update FOKONYV set FO_RT=FO_RT+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
         end else begin
           update FOKONYV set FO_RK=FO_RK+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
         end
       end
     end
   end else begin
     /* nyito */
     if (NEW.CO_IRANY='T') then begin
       update FOKONYV set FO_RT=FO_RT+NEW.CO_OSSZEG, FO_T=FO_T+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
     end else begin
       update FOKONYV set FO_RK=FO_RK+NEW.CO_OSSZEG, FO_K=FO_K+NEW.CO_OSSZEG, FO_US_NEV='TRSYS' where FO_KARTON=NEW.CO_FO_KARTON and FO_EV=NEW.CO_EV;
     end
   end

   /*** old UG ***/
   if (Old.CO_UG_ID>0) then begin
     select COUNT(*) X from UGYFEL where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON into :CNT ;
     if (CNT>0)  then begin
       if (Old.CO_STATUS='N') then begin
         if (Old.CO_IRANY='T') then begin
           update UGYFEL set UG_NT= UG_NT-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
         end else begin
           update UGYFEL set UG_NK= UG_NK-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
         end
       end else begin
         if ((Old.CO_STATUS='R') or (Old.CO_STATUS='Z'))  then begin
           if (Old.CO_IRANY='T') then begin
             update UGYFEL set UG_RT= UG_RT-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
           end else begin
             update UGYFEL set UG_RK= UG_RK-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
           end
         end else begin
           if (Old.CO_STATUS='E') then begin
             if (Old.CO_IRANY='T') then begin
               update UGYFEL set UG_RT= UG_RT-Old.CO_OSSZEG, UG_T= UG_T-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
             end else begin
               update UGYFEL set UG_RK= UG_RK-Old.CO_OSSZEG, UG_K= UG_K-Old.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=Old.CO_UG_ID and UG_EV=Old.CO_EV and UG_KARTON=Old.CO_FO_KARTON;
             end
           end
         end
       end
     end
   end
   /*** new UG ***/
   if (New.CO_UG_ID>0) then begin
     select COUNT(*) X from UGYFEL where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON into :CNT ;
     if (CNT>0)  then begin
       if (New.CO_STATUS='N') then begin
         if (New.CO_IRANY='T') then begin
           update UGYFEL set UG_NT= UG_NT+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
         end else begin
           update UGYFEL set UG_NK= UG_NK+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
         end
       end else begin
         if ((New.CO_STATUS='R') or (New.CO_STATUS='Z'))  then begin
           if (New.CO_IRANY='T') then begin
             update UGYFEL set UG_RT= UG_RT+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
           end else begin
             update UGYFEL set UG_RK= UG_RK+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
           end
         end else begin
           if (New.CO_STATUS='E') then begin
             if (New.CO_IRANY='T') then begin
               update UGYFEL set UG_RT= UG_RT+New.CO_OSSZEG, UG_T= UG_T+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
             end else begin
               update UGYFEL set UG_RK= UG_RK+New.CO_OSSZEG, UG_K= UG_K+New.CO_OSSZEG, UG_US_NEV='TRSYS' where UG_ID=New.CO_UG_ID and UG_EV=New.CO_EV and UG_KARTON=New.CO_FO_KARTON;
             end
           end
         end
       end
     end
   end
 end
 if ((Old.CO_OSSZEG<>New.CO_OSSZEG) or (Old.CO_FE_NAPLO<>New.CO_FE_NAPLO) or (Old.CO_MO_CHAR<>New.CO_MO_CHAR)) then begin
   if (Old.CO_IRANY='T') then begin
     update NAPLO set NA_T=NA_T-Old.CO_OSSZEG, NA_E=NA_E-Old.CO_OSSZEG where NA_TYP=Old.CO_MO_CHAR and NA_NO=Old.CO_FE_NAPLO and NA_EV=Old.CO_EV;
   end else begin
     update NAPLO set NA_K=NA_K-Old.CO_OSSZEG, NA_E=NA_E+Old.CO_OSSZEG where NA_TYP=Old.CO_MO_CHAR and NA_NO=Old.CO_FE_NAPLO and NA_EV=Old.CO_EV;
   end
   if (New.CO_IRANY='T') then begin
     update NAPLO set NA_T=NA_T+New.CO_OSSZEG, NA_E=NA_E+NEW.CO_OSSZEG where NA_TYP=New.CO_MO_CHAR and NA_NO=New.CO_FE_NAPLO and NA_EV=New.CO_EV;
   end else begin
     update NAPLO set NA_K=NA_K+New.CO_OSSZEG, NA_E=NA_E-NEW.CO_OSSZEG where NA_TYP=New.CO_MO_CHAR and NA_NO=New.CO_FE_NAPLO and NA_EV=New.CO_EV;
   end
 end
END^

/********** Osszepont *************/

CREATE TRIGGER OSSZEPONT_BI FOR OSSZEPONT BEFORE INSERT POSITION 0 AS
DECLARE VARIABLE A INTEGER;
DECLARE VARIABLE FEID INTEGER;
DECLARE VARIABLE C INTEGER;
DECLARE VARIABLE B1 NUMERIC(7,1);
DECLARE VARIABLE B2 NUMERIC(7,1);
DECLARE VARIABLE A1 NUMERIC(16,2);
DECLARE VARIABLE A2 NUMERIC(16,2);
DECLARE VARIABLE D1 NUMERIC(16,2);
DECLARE VARIABLE D2 NUMERIC(16,2);
DECLARE VARIABLE K1 NUMERIC(16,6);
DECLARE VARIABLE K2 NUMERIC(16,6);
DECLARE VARIABLE C1 CHAR(1);
DECLARE VARIABLE C2 CHAR(1);
DECLARE VARIABLE T1 TIMESTAMP;
DECLARE VARIABLE T2 TIMESTAMP;
DECLARE VARIABLE H1 TIMESTAMP;
DECLARE VARIABLE H2 TIMESTAMP;
DECLARE VARIABLE V1 varchar(3);
DECLARE VARIABLE V2 varchar(3);
DECLARE VARIABLE I1 CHAR(1);
DECLARE VARIABLE I2 CHAR(1);
DECLARE VARIABLE DELTA NUMERIC(16,2);
DECLARE VARIABLE SUMA NUMERIC(16,2);

BEGIN
  New.OS_TIME='now';
  New.OS_KESES=0;
  if (New.OS_MOD is NULL) then New.OS_MOD=0;
  select FE_IRANY,FE_DEVKURZ,FE_TOTAL,FE_DEVTOTAL,FE_EV,FE_MO_CHAR,FE_TELJESIT,FE_HATARIDO, FE_DEV from FEJLEC where FE_ID=NEW.OS_FE_ID_A INTO :I1,:K1,:A1,:D1, :B1, :C1, :T1, :H1,:V1 ;
  select FE_IRANY,FE_DEVKURZ,FE_TOTAL,FE_DEVTOTAL,FE_EV,FE_MO_CHAR,FE_TELJESIT,FE_HATARIDO, FE_DEV from FEJLEC where FE_ID=NEW.OS_FE_ID_B INTO :I2,:K2,:A2,:D2, :B2, :C2, :T2, :H2,:V2 ;
  if (New.OS_DEV<>'+') then begin
    if (Upper(V1)<>Upper(V2)) then begin
      EXCEPTION "EOSDEV";
    end
    if (New.OS_SUMA>0) then begin
      IF ((C1=C2) and (I1<>I2) and (A1=A2) and (D1=D2)) then New.OS_MOD=1;
      DELTA=0;
      if (V1>' ') then begin
        if (D1>D2) then begin
          SUMA=D2;
        end else begin
          SUMA=D1;
        end
        if (NEW.OS_SUMA>SUMA) then begin
          New.OS_SUMA=SUMA;
        end
        if ((C1='V') and (C2='B')) then begin
          /* csak banki kiegy eseten van arfolyam aut. konyvelese */
          if (I1='T') then begin
            DELTA=NEW.OS_SUMA*K2 - NEW.OS_SUMA*K1;
          end else begin
            DELTA=NEW.OS_SUMA*K1 - NEW.OS_SUMA*K2;
          end
        end
        if ((C1='S') and (C2='B')) then begin
          if (I1='K') then begin
            DELTA=NEW.OS_SUMA*K1 - NEW.OS_SUMA*K2;
          end else begin
            DELTA=NEW.OS_SUMA*K2 - NEW.OS_SUMA*K1;
          end
        end
        if ((C1='B') and (C2='V')) then begin
          if (I2='T') then begin
            DELTA=NEW.OS_SUMA*K1 - NEW.OS_SUMA*K2;
          end else begin
            DELTA=NEW.OS_SUMA*K2 - NEW.OS_SUMA*K1;
          end
        end
        if ((C1='B') and (C2='S')) then begin
          if (I2='K') then begin
            DELTA=NEW.OS_SUMA*K2 - NEW.OS_SUMA*K1;
          end else begin
            DELTA=NEW.OS_SUMA*K1 - NEW.OS_SUMA*K2;
          end
        end
      end else begin
        if (A2<A1) then begin
          SUMA=A2;
        end else begin
          SUMA=A1;
        end
        if (NEW.OS_SUMA>SUMA) then begin
          New.OS_SUMA=SUMA;
        end
      end
      NEW.OS_12=DELTA;
      FEID=0;
      if (DELTA<>0) then begin
        A=0;
        select count(*) from BEALL where BE_NEV='1' and BE_OK='Y' and BE_EV=New.OS_EV into :A ;
        if (A>0) then begin
          FEID=GEN_ID(FE,1);
          /* uj fejlec a arfolyam kulombozet konyvelesehez */
        end
      end
      NEW.OS_FEID=FEID;
      if (B2>B1) then B1=B2;
      NEW.OS_EV=B1;
      if (C1<>C2) then begin
        if ((C1='S') or (C1='V'))  then begin
          C= cast((cast(T2 as DATE) - cast(H1 as DATE)) as INTEGER);
          New.OS_KESES=C;
        end else begin
          C= cast((cast(T1 as DATE) - cast(H2 as DATE)) as INTEGER);
          New.OS_KESES=C;
        end
      end
      if (C1<>C2) then begin
        if ((C2='V') or (C2='S')) then begin
          C=NEW.OS_FE_ID_B;
          NEW.OS_FE_ID_B=NEW.OS_FE_ID_A;
          NEW.OS_FE_ID_A=C;
        end
      end
    end
  end else begin
    C= cast((cast(T2 as DATE) - cast(H1 as DATE)) as INTEGER);
    New.OS_KESES=C;
  end
END^


CREATE TRIGGER OSSZEPONT_AI FOR OSSZEPONT
  AFTER INSERT POSITION 0 AS
DECLARE VARIABLE A INTEGER;
DECLARE VARIABLE UGID INTEGER;
DECLARE VARIABLE UGKAR VARCHAR(16);
DECLARE VARIABLE UGTYP CHAR(1);
DECLARE VARIABLE UGTYP2 CHAR(1);
DECLARE VARIABLE IR CHAR(1);
DECLARE VARIABLE S CHAR(1);
DECLARE VARIABLE J CHAR(1);
DECLARE VARIABLE B VARCHAR(16);
DECLARE VARIABLE BB VARCHAR(16);
DECLARE VARIABLE CC1 VARCHAR(180);
DECLARE VARIABLE CC2 VARCHAR(180);
DECLARE VARIABLE H VARCHAR(16);
DECLARE VARIABLE KELT  TIMESTAMP;
DECLARE VARIABLE ELLEN VARCHAR(16);
DECLARE VARIABLE N INTEGER;
DECLARE VARIABLE NN INTEGER;
DECLARE VARIABLE SUMA NUMERIC(16,2);
BEGIN
  if (NEW.OS_SUMA<>0) then begin
    if (New.OS_DEV<>'+') then begin
      if (New.OS_MOD=1) then begin
        update FEJLEC set FE_KIEGY2=FE_KIEGY2+F_ROUNDBY(New.OS_SUMA*FE_DEVKURZ,2,2), FE_KIEGY=FE_KIEGY+NEW.OS_SUMA,FE_KESES=0, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and (FE_ID=NEW.OS_FE_ID_A or FE_ID=NEW.OS_FE_ID_B) ;
      end else begin
        if (New.OS_DEV>' ') then begin
          update FEJLEC set FE_KIEGY2=FE_KIEGY2+F_ROUNDBY(New.OS_SUMA*FE_DEVKURZ,2,2)-New.OS_12,FE_KIEGY=FE_KIEGY+NEW.OS_SUMA,FE_KESES=New.OS_KESES, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and FE_ID=NEW.OS_FE_ID_A;
          update FEJLEC set FE_KIEGY2=FE_KIEGY2+F_ROUNDBY(New.OS_SUMA*FE_DEVKURZ,2,2),FE_KIEGY=FE_KIEGY+NEW.OS_SUMA,FE_KESES=New.OS_KESES, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and FE_ID=NEW.OS_FE_ID_B;
        end else begin
          update FEJLEC set FE_KIEGY2=FE_KIEGY2+NEW.OS_SUMA,FE_KIEGY=FE_KIEGY+NEW.OS_SUMA,FE_KESES=New.OS_KESES, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and (FE_ID=NEW.OS_FE_ID_A or FE_ID=NEW.OS_FE_ID_B) ;
        end
      end
      if ((New.OS_FEID>0) and (New.OS_SUMA>0)) then begin
        select FE_KARTON, FE_MO_CHAR,FE_BIZONYLAT,FE_NAPLO from FEJLEC where FE_ID=New.OS_FE_ID_A and FE_EV=New.OS_EV into :UGKAR,:UGTYP,:BB,:N ;
        select FE_MO_CHAR, FE_IRANY,FE_STATUS,FE_BIZONYLAT,FE_HIVATKOZ,FE_UG_ID,FE_KELTE FROM FEJLEC where FE_ID=New.OS_FE_ID_B and FE_EV=New.OS_EV into :UGTYP2,:IR,:S,:B,:H,:UGID,:KELT ;
        SUMA=New.OS_12;
        ELLEN='';
        If (SUMA>0) then begin
          select FO_KARTON from FOKONYV where FO_TYP='1' and FO_COMPLET='Y' into :ELLEN ;
        end else begin
          select FO_KARTON from FOKONYV where FO_TYP='2' and FO_COMPLET='Y' into :ELLEN ;
        end
        if ((ELLEN is NULL) or (ELLEN='')) then begin
          EXCEPTION EOSK;
        end else begin
          J='S';
          if (SUMA>0) then begin
            IR='T';
            if (UGTYP='S') then J='J';
            /* nyereseg 1  mindig kovetel oldalra K-976 */
          end else begin
            IR='K';
            if (UGTYP='V') then J='J';
            /* veszteseg 2  mindig tartozik oldalra T-876 */
            SUMA=-SUMA;
          end
          NN=N;
          /*
          select NA_NO from NAPLO where NA_TYP=:UGTYP and NA_OWNER=New.OS_US_NEV and NA_EV=New.OS_EV  order by NA_NO DESC into :N ;
          if ((N is NULL) or (N<1)) then begin
            N=NN;
            select MAX(NA_NO)+1 from NAPLO where NA_TYP=:UGTYP and NA_EV=New.OS_EV into :N ;
            insert into NAPLO (NA_TYP,NA_EV,NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_FE_ID,NA_TIME,NA_RECNO) VALUES (:UGTYP, New.OS_EV,:N,0,0,0,New.OS_US_NEV,New.OS_FEID,'now',0);
            select NA_NO from NAPLO where NA_TYP=:UGTYP and NA_OWNER=New.OS_US_NEV and NA_EV=New.OS_EV  order by NA_NO DESC into :N ;
            if ((N is NULL) or (N<1)) then N=NN;
          end
          */
          CC1= UGTYP || BB || ':' || UGTYP2 || B || ' rfolyam klnbzet';
          CC2= UGTYP || BB || ':' || UGTYP2 || B || ' dif.course';
          insert INTO FEJLEC (FE_NAPLO, FE_MO_CHAR, FE_ID, FE_EV, FE_US_NEV, FE_IRANY, FE_KARTON, FE_BIZONYLAT,FE_HIVATKOZ,FE_UG_ID,FE_KELTE,FE_TOTAL,FE_MEGJEGY,FE_JELLEG,FE_OSMOD2,FE_DEVKURZ,FE_DEV,FE_KIEGY,FE_KIEGY2) VALUES
                             (:N, :UGTYP, New.OS_FEID ,New.OS_EV, New.OS_US_NEV, :IR,:UGKAR,:BB,:H,:UGID,:KELT,:SUMA,:CC1,:J,1,0,New.OS_DEV,0,:SUMA);
          insert INTO TETEL  (TE_ID,TE_FE_ID,TE_FE_IRANY, TE_ELLEN, TE_SUM,TE_US_NEV,TE_EV,TE_MEGJEGY,TE_MEGJEGY_E,TE_MEGJEGY_D) VALUES
                             (GEN_ID(TE,1),New.OS_FEID,:IR, :ELLEN, :SUMA, New.OS_US_NEV, New.OS_EV,:CC1,:CC2,:CC2);
          update FEJLEC set FE_KIEGY2=FE_KIEGY2+New.OS_12, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and FE_ID=NEW.OS_FE_ID_A;
        end
      end
    end else begin
      SUMA=New.OS_SUMA;
      if (New.OS_SUMA<0) then SUMA=-New.OS_SUMA;
      update FEJLEC set FE_KIEGY2=FE_KIEGY2+NEW.OS_SUMA, FE_KESES=New.OS_KESES, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and FE_ID=NEW.OS_FE_ID_A;
      update FEJLEC set FE_KIEGY2=FE_KIEGY2+:SUMA, FE_KIEGY=FE_KIEGY+:SUMA, FE_KESES=New.OS_KESES, FE_OSMOD=New.OS_MOD, FE_US_NEV='REBUILD' where FE_EV=NEW.OS_EV and FE_ID=NEW.OS_FE_ID_B;
    end
  end
END^


CREATE TRIGGER OSSZEPONT_AD FOR OSSZEPONT
  AFTER DELETE POSITION 0 AS
DECLARE VARIABLE SUMA NUMERIC(16,2);
BEGIN
  if (Old.OS_DEV<>'+') then begin
    if (Old.OS_DEV>' ') then begin
      if (Old.OS_MOD=1) then begin
        update FEJLEC set FE_KIEGY2=FE_KIEGY2-F_ROUNDBY(Old.OS_SUMA*FE_DEVKURZ,2,2), FE_KIEGY=FE_KIEGY-Old.OS_SUMA,FE_KESES=0, FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_EV=Old.OS_EV and (FE_ID=Old.OS_FE_ID_A or FE_ID=Old.OS_FE_ID_B) ;
      end else begin
        if (OLD.OS_FEID>0) then begin
          update FEJLEC set FE_US_NEV='REBUILD', FE_OSMOD2=0 where FE_ID=Old.OS_FEID;
          delete from FEJLEC where FE_ID=Old.OS_FEID;
          update FEJLEC set FE_KIEGY2=FE_KIEGY2-Old.OS_12, FE_KESES=0,FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_DEV>' ' and FE_EV=OLD.OS_EV and FE_ID=OLD.OS_FE_ID_A;
        end
        update FEJLEC set FE_KIEGY2=FE_KIEGY2-F_ROUNDBY(Old.OS_SUMA*FE_DEVKURZ,2,2)+Old.OS_12, FE_KIEGY=FE_KIEGY-OLD.OS_SUMA, FE_KESES=0,FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_DEV>' ' and FE_EV=OLD.OS_EV and FE_ID=OLD.OS_FE_ID_A;
        update FEJLEC set FE_KIEGY2=FE_KIEGY2-F_ROUNDBY(Old.OS_SUMA*FE_DEVKURZ,2,2),FE_KIEGY=FE_KIEGY-OLD.OS_SUMA, FE_KESES=0,FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_DEV>' ' and FE_EV=OLD.OS_EV and FE_ID=OLD.OS_FE_ID_B;
      end
    end else begin
      update FEJLEC set FE_KIEGY2=FE_KIEGY2-Old.OS_SUMA, FE_KIEGY=FE_KIEGY-OLD.OS_SUMA, FE_KESES=0,FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_EV=OLD.OS_EV and (FE_ID=OLD.OS_FE_ID_A or FE_ID=OLD.OS_FE_ID_B);
    end
  end else begin
    SUMA=Old.OS_SUMA;
    if (Old.OS_SUMA<0) then SUMA=-Old.OS_SUMA;
    update FEJLEC set FE_KIEGY2=FE_KIEGY2-Old.OS_SUMA, FE_KESES=0,FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_EV=OLD.OS_EV and FE_ID=OLD.OS_FE_ID_A ;
    update FEJLEC set FE_KIEGY2=FE_KIEGY2-:SUMA, FE_KIEGY=FE_KIEGY-:SUMA, FE_KESES=0, FE_OSMOD=0, FE_US_NEV='REBUILD' where FE_EV=OLD.OS_EV and FE_ID=Old.OS_FE_ID_B;
  end
END^


/********** AFA *************/

CREATE TRIGGER AFA_AI FOR AFA
  AFTER INSERT POSITION 0 AS
BEGIN
  New.AF_TIME='now';
END^

CREATE TRIGGER AFA_BD FOR AFA
BEFORE DELETE POSITION 0 AS
BEGIN
  IF ((OLD.AF_NEV='') and (OLD.AF_US_NEV='SYSTEM')) then begin
    EXCEPTION ENONE;
  end
END^

CREATE TRIGGER AFA_BU FOR AFA
BEFORE UPDATE POSITION 0 AS
BEGIN
  IF ((OLD.AF_NEV='') and (OLD.AF_US_NEV='SYSTEM')) then begin
    EXCEPTION ENONE;
  end
END^

CREATE TRIGGER AFA_AU FOR AFA
  AFTER UPDATE POSITION 0 AS
BEGIN
  if (NEW.AF_US_NEV='TRSYS') then begin
    NEW.AF_TIME=OLD.AF_TIME;
    NEW.AF_US_NEV=OLD.AF_US_NEV;
  end else begin
    New.AF_TIME='now';
  end
END^


/********** FOKONYV *************/

CREATE TRIGGER FOKONYV_BI FOR FOKONYV BEFORE INSERT POSITION 0 AS
BEGIN
  New.FO_TIME='now';
  if (New.FO_T is NULL) then New.FO_T=0;
  if (New.FO_K is NULL) then New.FO_K=0;
  if (New.FO_NT is NULL) then New.FO_NT=0;
  if (New.FO_NK is NULL) then New.FO_NK=0;
  if (New.FO_RT is NULL) then New.FO_RT=0;
  if (New.FO_RK is NULL) then New.FO_RK=0;
END^

CREATE TRIGGER FOKONYV_BU FOR FOKONYV BEFORE UPDATE POSITION 0 AS
BEGIN
  if (New.FO_US_NEV='TRSYS') then  begin
    New.FO_TIME=Old.FO_TIME;
    New.FO_US_NEV=Old.FO_US_NEV;
  end else begin
    New.FO_TIME='now';
  end
END^

/********** UGYFEL *************/

CREATE TRIGGER UGYFEL_BI FOR UGYFEL BEFORE INSERT POSITION 0 AS
BEGIN
  New.UG_TIME='now';
  if (New.UG_T is NULL) then New.UG_T=0;
  if (New.UG_K is NULL) then New.UG_K=0;
  if (New.UG_NT is NULL) then New.UG_NT=0;
  if (New.UG_NK is NULL) then New.UG_NK=0;
  if (New.UG_RT is NULL) then New.UG_RT=0;
  if (New.UG_RK is NULL) then New.UG_RK=0;
END^

CREATE TRIGGER UGYFEL_BU FOR UGYFEL BEFORE UPDATE POSITION 0 AS
BEGIN
  if ((OLD.UG_ROVID='') and (OLD.UG_ID=0))  then begin
    if ((NEW.UG_ID<>0) or (NEW.UG_ROVID<>'') or (NEW.UG_CEG<>'')) then EXCEPTION ENONE;
  end
  if (NEW.UG_US_NEV='TRSYS') then begin
    New.UG_TIME=Old.UG_TIME;
    NEW.UG_US_NEV=Old.UG_US_NEV;
  end else begin
    New.UG_TIME='now';
  end
END^

CREATE TRIGGER UGYFEL_BD FOR UGYFEL BEFORE DELETE POSITION 0 AS
BEGIN
  if ((OLD.UG_ROVID='') and (OLD.UG_ID=0)) then begin
    EXCEPTION ENONE;
  end
END^

/***********************/

CREATE TRIGGER USR_BIU FOR USR BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN
  New.US_TIME='now';
  if ( (Upper(New.US_NEV)='SYSTEM') or (Upper(New.US_NEV)='TRSYS') ) then begin
    EXCEPTION EUSR;
  end
END^

CREATE TRIGGER LOGINS_BI FOR LOGINS BEFORE INSERT POSITION 0 AS
BEGIN New.LO_TIME='now';  END^

CREATE TRIGGER JOGOK_BIU FOR JOGOK BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.JO_TIME='now'; END^

CREATE TRIGGER MERLEG_BIU FOR MERLEG BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.ME_TIME='now'; END^

CREATE TRIGGER GYUJTO_BIU FOR GYUJTO BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.GY_TIME='now'; END^

CREATE TRIGGER MODOZAT_BIU FOR MODOZAT BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.MO_TIME='now'; END^

CREATE TRIGGER JELLEG_BIU FOR JELLEG BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.JE_TIME='now'; END^

CREATE TRIGGER SABLON_BIU FOR SABLON BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.SA_TIME='now'; END^

CREATE TRIGGER AFAZAR_BIU FOR AFAZAR BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.AZ_TIME='now'; END^

CREATE TRIGGER FELAFA_BIU FOR FELAFA BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.FA_TIME='now'; END^

CREATE TRIGGER FELCSOP_BIU FOR FELCSOP BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.CS_TIME='now'; END^

CREATE TRIGGER VERSION_BIU FOR VERSION BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.VE_TIME='now'; END^

CREATE TRIGGER AFAZAR_AD FOR AFAZAR AFTER DELETE POSITION 0 AS
BEGIN
  update FEJLEC set FE_AZ_ID=0, FE_US_NEV='TRSYS'  where FE_AZ_ID=Old.AZ_ID;
  update CONTIR set CO_AZ_ID=0, CO_US_NEV='TRSYS'  where CO_AZ_ID=Old.AZ_ID;
END^

CREATE TRIGGER EVZAR_BIU FOR EVZAR BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.EV_TIME='now'; END^

CREATE TRIGGER IDOZAR_BIU FOR IDOZAR BEFORE INSERT OR UPDATE POSITION 0 AS
BEGIN New.ID_TIME='now'; END^

CREATE PROCEDURE ACT_NAPLO ( NP INTEGER, A CHAR(1), EV NUMERIC(7,1), OWN varchar(16) )
RETURNS ( N INTEGER,R INTEGER, T NUMERIC(16, 2), K NUMERIC(16, 2), E NUMERIC(16, 2), OW varchar(16), FEID integer)
AS
BEGIN
 /** NP<-1  insert new record NA_NO=NA_NO+1 ; NP=-1 - get max NA_NO ; NP>0 get NA_NO=NP **/
  if (NP>=0) then begin
    select NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_RECNO,NA_FE_ID from NAPLO where NA_TYP=:A and NA_EV=:EV and NA_NO=:NP into :N,:T,:K,:E,:OW,:R,:FEID ;
    if (N is NULL) then begin
      N=-1; T=0; K=0; E=0; R=0; OW=OWN; FEID=0;
    end
  end else begin
    if (NP=-1) then begin
      select First 1 NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_RECNO,NA_FE_ID from NAPLO where NA_TYP=:A and NA_EV=:EV order by NA_NO DESC into :N,:T,:K,:E,:OW,:R,:FEID;
      if (N is null) then begin
        N=1;
        FEID=1+GEN_ID(FE,0);
        insert into NAPLO (NA_TYP,NA_EV,NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_FE_ID,NA_TIME,NA_RECNO) VALUES (:A,:EV,1,0,0,0,:OWN,:FEID,'now',0);
        N=1; T=0; K=0; E=0; R=0; OW=OWN;
      end
    end else begin
      select MAX(NA_NO) from NAPLO where NA_TYP=:A and NA_EV=:EV into :N ;
      if (N is NULL) then N=0;
      N=N+1;
      FEID=1+GEN_ID(FE,0);
      insert into NAPLO (NA_TYP,NA_EV,NA_NO,NA_T,NA_K,NA_E,NA_OWNER,NA_FE_ID,NA_TIME,NA_RECNO) VALUES (:A,:EV,:N,0,0,0,:OWN,:FEID,'now',0);
      T=0; K=0; E=0; R=0; OW=OWN;
    end
  end
  if (T is NULL) then T=0;
  if (K is NULL) then K=0;
  if (R is NULL) then R=0;
  if (OW is NULL) then OW='';
  if (N is NULL) then N=-1;
  if (FEID is NULL) then FEID=0;
END^

CREATE PROCEDURE FE_OS (ID integer)
RETURNS ( FE INTEGER, OS INTEGER, S NUMERIC(16,2) ,KES INTEGER, DEV VARCHAR(3))
AS
DECLARE VARIABLE A INTEGER;
DECLARE VARIABLE B INTEGER;
DECLARE VARIABLE D varchar(3);
DECLARE VARIABLE FEID INTEGER;
DECLARE VARIABLE OS12 NUMERIC(16,2);
BEGIN
  For select OS_SUMA,OS_FE_ID_A,OS_FE_ID_B,OS_ID, OS_KESES, OS_DEV, OS_FEID,OS_12 from OSSZEPONT where OS_FE_ID_A=:ID or OS_FE_ID_B=:ID or OS_FEID=:ID into :S, :A, :B, :OS, :KES, :DEV, :FEID, :OS12
  DO
  begin
    if (A=ID) then begin
      FE=B;
      suspend;
      if ((FEID>0) and (OS12>0)) then begin
        FE=-FEID; DEV='+'; S=OS12; KES=0;
        suspend;
      end
    end
    if (B=ID) then begin
      FE=A;
      suspend;
      if ((FEID>0) and (OS12>0)) then begin
        FE=-FEID; DEV='+'; S=OS12; KES=0;
        suspend;
      end
    end
    if ((FEID=ID) and (OS12>0)) then begin
      FE=-B; DEV='+'; S=OS12; KES=0;
      suspend;
    end
  end
END^

CREATE PROCEDURE START  AS
DECLARE VARIABLE A integer;
DECLARE VARIABLE B integer;
begin
  select Max(CO_ID) G from CONTIR  INTO :A;
  B=gen_id(CO,0); A=gen_id(CO,A-B);

  select Max(FE_ID) G from FEJLEC  INTO :A;
  B=gen_id(FE,0); A=gen_id(FE,A-B);

  select Max(OS_ID) G from OSSZEPONT  INTO :A;
  B=gen_id(OS,0); A=gen_id(OS,A-B);

  select Max(TE_ID) G from TETEL  INTO :A;
  B=gen_id(TE,0); A=gen_id(TE,A-B);

  select Max(UG_ID) G from UGYFEL  INTO :A;
  B=gen_id(UG,0); A=gen_id(UG,A-B);

  select Max(AZ_ID) G from AFAZAR  INTO :A;
  B=gen_id(AZ,0); A=gen_id(AZ,A-B);

END^


CREATE PROCEDURE FEID_NAPLO
AS
DECLARE VARIABLE N INTEGER;
DECLARE VARIABLE E double precision;
DECLARE VARIABLE F INTEGER;
DECLARE VARIABLE M VARCHAR(1);

DECLARE VARIABLE A INTEGER;
DECLARE VARIABLE B INTEGER;
DECLARE VARIABLE C INTEGER;
DECLARE VARIABLE C1 CHAR(1);
DECLARE VARIABLE C2 CHAR(1);
DECLARE VARIABLE T1 TIMESTAMP;
DECLARE VARIABLE T2 TIMESTAMP;
DECLARE VARIABLE H1 TIMESTAMP;
DECLARE VARIABLE H2 TIMESTAMP;
DECLARE VARIABLE ID INTEGER;
DECLARE VARIABLE M1 INTEGER;
DECLARE VARIABLE M2 INTEGER;
BEGIN
  FOR select NA_NO,NA_EV, NA_TYP from NAPLO order by NA_EV,NA_NO INTO :N, :E, :M do
  begin
    select MIN(FE_ID) FROM FEJLEC where FE_MO_CHAR=:M and FE_NAPLO=:N and FE_EV=:E INTO :F;
    if (F is null) then F=0;
    update NAPLO set NA_FE_ID=:F where NA_NO=:N and NA_TYP=:M and NA_EV=:E;
  end
  update FEJLEC set FE_US_NEV='REBUILD', FE_SUMAR=FE_DEVTOTAL, FE_KIEGY2=F_ROUNDBY(FE_KIEGY*FE_DEVKURZ,2,2) where FE_DEV>' ';
  update FEJLEC set FE_US_NEV='REBUILD', FE_SUMAR=FE_TOTAL, FE_KIEGY2=FE_KIEGY where FE_DEV<=' ';
  FOR select OS_FE_ID_A, OS_FE_ID_B, OS_ID from OSSZEPONT order by OS_ID INTO :A, :B, :ID do
  begin
    select FE_MO_CHAR, FE_TELJESIT, FE_HATARIDO,FE_OSMOD from FEJLEC where FE_ID=:A INTO :C1,:T1,:H1,:M1 ;
    select FE_MO_CHAR, FE_TELJESIT, FE_HATARIDO,FE_OSMOD from FEJLEC where FE_ID=:B INTO :C2,:T2,:H2,:M2 ;
    C=0;
    if ((M1=M2) and (M1=1)) then begin
      update OSSZEPONT set OS_KESES=0 where OS_ID=:ID ;
      update FEJLEC set FE_KESES=0, FE_US_NEV='REBUILD' where FE_ID=:A or FE_ID=:B;
    end else begin
      if (C1<>C2) then begin
         /* not storno */
        if (((C1='S') or (C1='V')) and (C2<>'S') and (C2<>'V')) then begin
          C= cast((cast(T2 as DATE) - cast(H1 as DATE)) as INTEGER);
          update OSSZEPONT set OS_KESES=:C where OS_ID=:ID ;
          update FEJLEC set FE_KESES=:C, FE_US_NEV='REBUILD' where FE_ID=:A or FE_ID=:B;
        end
        if (((C2='S') or (C2='V')) and (C1<>'S') and (C1<>'V')) then begin
          C= cast((cast(T1 as DATE) - cast(H2 as DATE)) as INTEGER);
          update OSSZEPONT set OS_KESES=:C where OS_ID=:ID ;
          update FEJLEC set FE_KESES=:C, FE_US_NEV='REBUILD' where FE_ID=:A or FE_ID=:B;
        end
      end
    end
  end
END^

CREATE PROCEDURE FO_REBUILD(EV double precision)
AS
DECLARE VARIABLE KA VARCHAR(16);
DECLARE VARIABLE S double precision;
DECLARE VARIABLE A integer;
DECLARE VARIABLE T double precision;
DECLARE VARIABLE K double precision;
DECLARE VARIABLE E double precision;
DECLARE VARIABLE C integer;
DECLARE VARIABLE UG integer;
DECLARE VARIABLE NA integer;
DECLARE VARIABLE NAT CHAR(1);
DECLARE VARIABLE M1 CHAR(1);
DECLARE VARIABLE M2 CHAR(1);
BEGIN

  delete FROM FEJLEC where FE_EV=:EV and FE_UG_ID not in (select UG_ID from UGYFEL where UG_EV=:EV);
  For select FE_ID from FEJLEC where FE_EV=:EV and FE_DEVTOTAL>=0.01 and FE_TOTAL>=0.01 and F_ABS(F_ROUNDBY(FE_DEVTOTAL*FE_DEVKURZ,2,2)-FE_TOTAL)>=0.01 into :C do
  begin
    update FEJLEC set FE_DEVKURZ= cast (FE_TOTAL as numeric(16,6)) / cast (FE_DEVTOTAL as numeric(16,6)) , FE_US_NEV='REBUILD' where FE_EV=:EV and FE_ID=:C;
  end
  For select FE_ID from FEJLEC where FE_OSMOD2=0 and FE_EV=:EV and (FE_KIEGY<>0 or FE_KIEGY2<>0) and
     (FE_ID not in (select OS_FE_ID_A from OSSZEPONT where OS_EV=:EV)) and
     (FE_ID not in (select OS_FE_ID_B from OSSZEPONT where OS_EV=:EV)) into :C do
  begin
    update FEJLEC set FE_KIEGY=0, FE_KIEGY2=0, FE_US_NEV='REBUILD', FE_OSMOD=0, FE_OSMOD2=0 where FE_EV=:EV and FE_ID=:C ;
  end

  update FEJLEC set FE_KESES=0, FE_KIEGY=0, FE_SUMAR=0, FE_KIEGY2=FE_TOTAL, FE_US_NEV='REBUILD'
    where FE_OSMOD2=1 and (FE_KIEGY2<>FE_TOTAL) and FE_EV=:EV;

  update FEJLEC set FE_KESES=0, FE_KIEGY=0, FE_SUMAR=0, FE_KIEGY2=FE_TOTAL, FE_OSMOD2=1, FE_DEVTOTAL=0, FE_OSMOD=0, FE_US_NEV='REBUILD'
    where FE_KIEGY2<>FE_TOTAL and (FE_ID in (select OS_FEID from OSSZEPONT where OS_FEID>0 and OS_12<>0 and OS_EV=:EV));

  update TETEL set TE_US_NEV='TRSYS',TE_AFASZAMLA='', TE_ATVEZ1='', TE_ATVEZ2=''
    where TE_FE_ID in (select FE_ID from FEJLEC where  FE_OSMOD2=1 and FE_EV=:EV);

  FOR select FO_KARTON from FOKONYV where FO_COMPLET='Y' and FO_EV=:EV order by FO_KARTON INTO :KA do
  begin
    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR where CO_FO_KARTON=:KA and CO_EV=:EV and CO_STATUS='N' and CO_MO_CHAR<>'N' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update FOKONYV set FO_NT=:T, FO_NK=:K, FO_US_NEV='TRSYS' where FO_KARTON=:KA and FO_EV=:EV;

    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR where CO_FO_KARTON=:KA and CO_EV=:EV and CO_STATUS<>'N' and CO_STATUS<>'E' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update FOKONYV set FO_RT=:T, FO_RK=:K, FO_US_NEV='TRSYS' where FO_KARTON=:KA and FO_EV=:EV;

    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR where CO_FO_KARTON=:KA and CO_EV=:EV and CO_MO_CHAR='N' and CO_STATUS<>'E' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update FOKONYV set FO_T=:T, FO_K=:K, FO_US_NEV='TRSYS' where FO_KARTON=:KA and FO_EV=:EV;
  end

  FOR select UG_ID,UG_KARTON,UG_MOD from UGYFEL where UG_ID>0 and UG_EV=:EV order by UG_ID INTO :UG, :KA, :M1 do
  begin
    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR,FEJLEC  where CO_FE_ID=FE_ID and FE_UG_ID=:UG and CO_FO_KARTON=:KA and CO_EV=:EV and FE_EV=:EV and CO_STATUS='N' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update UGYFEL set UG_NT=:T, UG_NK=:K, UG_US_NEV='TRSYS' where UG_ID=:UG and UG_EV=:EV and UG_KARTON=:KA;

    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR,FEJLEC  where CO_FE_ID=FE_ID and FE_UG_ID=:UG and CO_FO_KARTON=:KA and CO_EV=:EV and FE_EV=:EV and CO_STATUS<>'N' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update UGYFEL set UG_RT=:T, UG_RK=:K, UG_US_NEV='TRSYS' where UG_ID=:UG and UG_EV=:EV and UG_KARTON=:KA;

    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR,FEJLEC  where CO_FE_ID=FE_ID and FE_UG_ID=:UG and CO_FO_KARTON=:KA and CO_EV=:EV and FE_EV=:EV and CO_STATUS='E' into :K, :T ;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    update UGYFEL set UG_T=:T, UG_K=:K, UG_US_NEV='TRSYS' where UG_ID=:UG and UG_EV=:EV and UG_KARTON=:KA;

    select FO_TYP from FOKONYV where FO_EV=:EV and FO_KARTON=:KA into :M2 ;
    if ((M2 is not null) and (M2>' ') and (M1<>M2)) then begin
      if ((M2='S') or (M2='s') or (M2='v') or (M2='V') or (M2='P') or (M2='p')) then begin
        update UGYFEL set UG_MOD=:M2, UG_US_NEV='TRSYS' where UG_ID=:UG and UG_EV=:EV;
      end
    end
  end

  FOR select NA_NO,NA_TYP from NAPLO where NA_NO>0 and NA_EV=:EV order by NA_TYP,NA_NO INTO :NA, :NAT do
  begin
    select COUNT(*) C  From FEJLEC  where FE_NAPLO=:NA and FE_EV=:EV and FE_MO_CHAR=:NAT into :C ;
    select SUM(CO_K) K ,SUM(CO_T) T From CONTIR  where CO_FE_NAPLO=:NA and CO_EV=:EV and CO_MO_CHAR=:NAT into :K, :T ;
    if (C is NULL) then C=0;
    if (T is NULL) then T=0;
    if (K is NULL) then K=0;
    E=T-K;
    update NAPLO set NA_T=:T, NA_K=:K, NA_E=:E, NA_RECNO=:C where NA_TYP=:NAT and NA_NO=:NA and NA_EV=:EV;
  end

  EXECUTE PROCEDURE START;

END^

SET TERM ; ^

commit;

INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('V', 'Vev', NULL, '29.12.2004 0:59:46');
INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('S', 'Szllt', NULL, '29.12.2004 0:59:46');
INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('B', 'Bank', NULL, '29.12.2004 0:59:46');
INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('P', 'Pnztr', NULL, '29.12.2004 0:59:46');
INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('X', 'Vegyes', NULL, '29.12.2004 0:59:46');
INSERT INTO "MODOZAT" ("MO_CHAR", "MO_MEGNEV", "MO_US_NEV", "MO_TIME") VALUES ('N', 'Nyit', NULL, '29.12.2004 0:59:46');

commit;

INSERT INTO "JELLEG" ("JE_CHAR", "JE_MEGNEV", "JE_MOD", "JE_IRANY", "JE_US_NEV", "JE_TIME") VALUES ('S', 'Szmla', 'SV', 'KTT', NULL, '2005.01.04. 6:35:37');
INSERT INTO "JELLEG" ("JE_CHAR", "JE_MEGNEV", "JE_MOD", "JE_IRANY", "JE_US_NEV", "JE_TIME") VALUES ('J', 'Jvrs ', 'SV', 'TKK', NULL, '2005.01.04. 6:35:37');
INSERT INTO "JELLEG" ("JE_CHAR", "JE_MEGNEV", "JE_MOD", "JE_IRANY", "JE_US_NEV", "JE_TIME") VALUES ('X', 'Storno', 'SVN', 'TKK', NULL, '2005.01.06. 15:45:08');
INSERT INTO "JELLEG" ("JE_CHAR", "JE_MEGNEV", "JE_MOD", "JE_IRANY", "JE_US_NEV", "JE_TIME") VALUES ('B', 'Bevtel', 'PBXN', 'TTTT', NULL, '2005.01.06. 15:17:56');
INSERT INTO "JELLEG" ("JE_CHAR", "JE_MEGNEV", "JE_MOD", "JE_IRANY", "JE_US_NEV", "JE_TIME") VALUES ('K', 'Kiads', 'PBXN', 'KKKK', NULL, '2005.01.06. 15:17:51');

commit;

INSERT INTO "JOGOK" ("JO_NEV", "JO_LEIRAS", "JO_MENU", "JO_US_NEV", "JO_TIME") VALUES ('ALL', 'Minden', '', NULL, '1.1.2005 23:46:37');
INSERT INTO "USR" ("US_NEV", "US_VNEV", "US_KNEV", "US_PWD", "US_JO_NEV", "US_US_NEV", "US_TIME") VALUES ('ADMIN', NULL, NULL, '', 'ALL', NULL, '1.1.2005 23:45:32');

commit;

INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('1', 0, 'N', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('2', 0, 'Y', '', 60, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('3', 0, 'Y', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('4', 0, 'Y', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('5', 0, 'Y', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('6', 0, 'N', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');
INSERT INTO "BEALL" ("BE_NEV", "BE_TAG", "BE_OK", "BE_STR", "BE_NUM", "BE_DAT", "BE_EV", "BE_US_NEV", "BE_TIME") VALUES ('7', 0, 'N', '', 0, '10.4.2005 14:09:11', 2005, 'ADMIN', '10.4.2005 14:09:11');

commit;

DELETE FROM VERSION;
INSERT INTO VERSION (VE_NUM) VALUES ('0901');

commit;

EXECUTE PROCEDURE START;


commit;

